# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180222


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OpenIdConnectDiscovery(object):
    """
    The property that define the status of the OIDC Discovery feature for a cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OpenIdConnectDiscovery object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_open_id_connect_discovery_enabled:
            The value to assign to the is_open_id_connect_discovery_enabled property of this OpenIdConnectDiscovery.
        :type is_open_id_connect_discovery_enabled: bool

        """
        self.swagger_types = {
            'is_open_id_connect_discovery_enabled': 'bool'
        }
        self.attribute_map = {
            'is_open_id_connect_discovery_enabled': 'isOpenIdConnectDiscoveryEnabled'
        }
        self._is_open_id_connect_discovery_enabled = None

    @property
    def is_open_id_connect_discovery_enabled(self):
        """
        Gets the is_open_id_connect_discovery_enabled of this OpenIdConnectDiscovery.
        Whether the cluster has OIDC Discovery enabled. Defaults to false. If set to true, the cluster will be assigned a public OIDC Discovery endpoint.


        :return: The is_open_id_connect_discovery_enabled of this OpenIdConnectDiscovery.
        :rtype: bool
        """
        return self._is_open_id_connect_discovery_enabled

    @is_open_id_connect_discovery_enabled.setter
    def is_open_id_connect_discovery_enabled(self, is_open_id_connect_discovery_enabled):
        """
        Sets the is_open_id_connect_discovery_enabled of this OpenIdConnectDiscovery.
        Whether the cluster has OIDC Discovery enabled. Defaults to false. If set to true, the cluster will be assigned a public OIDC Discovery endpoint.


        :param is_open_id_connect_discovery_enabled: The is_open_id_connect_discovery_enabled of this OpenIdConnectDiscovery.
        :type: bool
        """
        self._is_open_id_connect_discovery_enabled = is_open_id_connect_discovery_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
