# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200131


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAdhocQueryDetails(object):
    """
    Details for creating adhoc query.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAdhocQueryDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateAdhocQueryDetails.
        :type compartment_id: str

        :param adhoc_query_details:
            The value to assign to the adhoc_query_details property of this CreateAdhocQueryDetails.
        :type adhoc_query_details: oci.cloud_guard.models.AdhocQueryDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateAdhocQueryDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateAdhocQueryDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'adhoc_query_details': 'AdhocQueryDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'adhoc_query_details': 'adhocQueryDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._adhoc_query_details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateAdhocQueryDetails.
        Compartment OCID of adhoc query


        :return: The compartment_id of this CreateAdhocQueryDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateAdhocQueryDetails.
        Compartment OCID of adhoc query


        :param compartment_id: The compartment_id of this CreateAdhocQueryDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def adhoc_query_details(self):
        """
        **[Required]** Gets the adhoc_query_details of this CreateAdhocQueryDetails.

        :return: The adhoc_query_details of this CreateAdhocQueryDetails.
        :rtype: oci.cloud_guard.models.AdhocQueryDetails
        """
        return self._adhoc_query_details

    @adhoc_query_details.setter
    def adhoc_query_details(self, adhoc_query_details):
        """
        Sets the adhoc_query_details of this CreateAdhocQueryDetails.

        :param adhoc_query_details: The adhoc_query_details of this CreateAdhocQueryDetails.
        :type: oci.cloud_guard.models.AdhocQueryDetails
        """
        self._adhoc_query_details = adhoc_query_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateAdhocQueryDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`

        Avoid entering confidential information.


        :return: The freeform_tags of this CreateAdhocQueryDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateAdhocQueryDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`

        Avoid entering confidential information.


        :param freeform_tags: The freeform_tags of this CreateAdhocQueryDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateAdhocQueryDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateAdhocQueryDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateAdhocQueryDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateAdhocQueryDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
