# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220509


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceNetworkInterfaceAssociation(object):
    """
    Describes association information for an Elastic IP address (IPv4).
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceNetworkInterfaceAssociation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param carrier_ip:
            The value to assign to the carrier_ip property of this InstanceNetworkInterfaceAssociation.
        :type carrier_ip: str

        :param customer_owned_ip:
            The value to assign to the customer_owned_ip property of this InstanceNetworkInterfaceAssociation.
        :type customer_owned_ip: str

        :param ip_owner_key:
            The value to assign to the ip_owner_key property of this InstanceNetworkInterfaceAssociation.
        :type ip_owner_key: str

        :param public_dns_name:
            The value to assign to the public_dns_name property of this InstanceNetworkInterfaceAssociation.
        :type public_dns_name: str

        :param public_ip:
            The value to assign to the public_ip property of this InstanceNetworkInterfaceAssociation.
        :type public_ip: str

        """
        self.swagger_types = {
            'carrier_ip': 'str',
            'customer_owned_ip': 'str',
            'ip_owner_key': 'str',
            'public_dns_name': 'str',
            'public_ip': 'str'
        }
        self.attribute_map = {
            'carrier_ip': 'carrierIp',
            'customer_owned_ip': 'customerOwnedIp',
            'ip_owner_key': 'ipOwnerKey',
            'public_dns_name': 'publicDnsName',
            'public_ip': 'publicIp'
        }
        self._carrier_ip = None
        self._customer_owned_ip = None
        self._ip_owner_key = None
        self._public_dns_name = None
        self._public_ip = None

    @property
    def carrier_ip(self):
        """
        Gets the carrier_ip of this InstanceNetworkInterfaceAssociation.
        The carrier IP address associated with the network interface.


        :return: The carrier_ip of this InstanceNetworkInterfaceAssociation.
        :rtype: str
        """
        return self._carrier_ip

    @carrier_ip.setter
    def carrier_ip(self, carrier_ip):
        """
        Sets the carrier_ip of this InstanceNetworkInterfaceAssociation.
        The carrier IP address associated with the network interface.


        :param carrier_ip: The carrier_ip of this InstanceNetworkInterfaceAssociation.
        :type: str
        """
        self._carrier_ip = carrier_ip

    @property
    def customer_owned_ip(self):
        """
        Gets the customer_owned_ip of this InstanceNetworkInterfaceAssociation.
        The customer-owned IP address associated with the network interface.


        :return: The customer_owned_ip of this InstanceNetworkInterfaceAssociation.
        :rtype: str
        """
        return self._customer_owned_ip

    @customer_owned_ip.setter
    def customer_owned_ip(self, customer_owned_ip):
        """
        Sets the customer_owned_ip of this InstanceNetworkInterfaceAssociation.
        The customer-owned IP address associated with the network interface.


        :param customer_owned_ip: The customer_owned_ip of this InstanceNetworkInterfaceAssociation.
        :type: str
        """
        self._customer_owned_ip = customer_owned_ip

    @property
    def ip_owner_key(self):
        """
        Gets the ip_owner_key of this InstanceNetworkInterfaceAssociation.
        The ID of the owner of the Elastic IP address.


        :return: The ip_owner_key of this InstanceNetworkInterfaceAssociation.
        :rtype: str
        """
        return self._ip_owner_key

    @ip_owner_key.setter
    def ip_owner_key(self, ip_owner_key):
        """
        Sets the ip_owner_key of this InstanceNetworkInterfaceAssociation.
        The ID of the owner of the Elastic IP address.


        :param ip_owner_key: The ip_owner_key of this InstanceNetworkInterfaceAssociation.
        :type: str
        """
        self._ip_owner_key = ip_owner_key

    @property
    def public_dns_name(self):
        """
        Gets the public_dns_name of this InstanceNetworkInterfaceAssociation.
        The public DNS name.


        :return: The public_dns_name of this InstanceNetworkInterfaceAssociation.
        :rtype: str
        """
        return self._public_dns_name

    @public_dns_name.setter
    def public_dns_name(self, public_dns_name):
        """
        Sets the public_dns_name of this InstanceNetworkInterfaceAssociation.
        The public DNS name.


        :param public_dns_name: The public_dns_name of this InstanceNetworkInterfaceAssociation.
        :type: str
        """
        self._public_dns_name = public_dns_name

    @property
    def public_ip(self):
        """
        Gets the public_ip of this InstanceNetworkInterfaceAssociation.
        The public IP address or Elastic IP address bound to the network interface.


        :return: The public_ip of this InstanceNetworkInterfaceAssociation.
        :rtype: str
        """
        return self._public_ip

    @public_ip.setter
    def public_ip(self, public_ip):
        """
        Sets the public_ip of this InstanceNetworkInterfaceAssociation.
        The public IP address or Elastic IP address bound to the network interface.


        :param public_ip: The public_ip of this InstanceNetworkInterfaceAssociation.
        :type: str
        """
        self._public_ip = public_ip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
