# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210224


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NameConstraint(object):
    """
    A constraint that specifies permitted and excluded namespaces for the hierarchical name forms in certificates that any CA in the certificate chain issues. You can define name constraints on a directory name, DNS address, or IP address. If you have a name constraint, you must define at least one permitted namespace or one excluded namespace.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NameConstraint object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param permitted_subtree:
            The value to assign to the permitted_subtree property of this NameConstraint.
        :type permitted_subtree: list[oci.certificates_management.models.NameConstraintSubtreeNode]

        :param excluded_subtree:
            The value to assign to the excluded_subtree property of this NameConstraint.
        :type excluded_subtree: list[oci.certificates_management.models.NameConstraintSubtreeNode]

        """
        self.swagger_types = {
            'permitted_subtree': 'list[NameConstraintSubtreeNode]',
            'excluded_subtree': 'list[NameConstraintSubtreeNode]'
        }
        self.attribute_map = {
            'permitted_subtree': 'permittedSubtree',
            'excluded_subtree': 'excludedSubtree'
        }
        self._permitted_subtree = None
        self._excluded_subtree = None

    @property
    def permitted_subtree(self):
        """
        Gets the permitted_subtree of this NameConstraint.
        A list that contains permitted namespaces. If you have a name constraint with no excluded namespaces, you must specify at least one permitted namespace.


        :return: The permitted_subtree of this NameConstraint.
        :rtype: list[oci.certificates_management.models.NameConstraintSubtreeNode]
        """
        return self._permitted_subtree

    @permitted_subtree.setter
    def permitted_subtree(self, permitted_subtree):
        """
        Sets the permitted_subtree of this NameConstraint.
        A list that contains permitted namespaces. If you have a name constraint with no excluded namespaces, you must specify at least one permitted namespace.


        :param permitted_subtree: The permitted_subtree of this NameConstraint.
        :type: list[oci.certificates_management.models.NameConstraintSubtreeNode]
        """
        self._permitted_subtree = permitted_subtree

    @property
    def excluded_subtree(self):
        """
        Gets the excluded_subtree of this NameConstraint.
        A list that contains excluded (or prohibited) namespaces. If you have a name constraint with no permitted namespaces, you must specify at least one excluded namespace.


        :return: The excluded_subtree of this NameConstraint.
        :rtype: list[oci.certificates_management.models.NameConstraintSubtreeNode]
        """
        return self._excluded_subtree

    @excluded_subtree.setter
    def excluded_subtree(self, excluded_subtree):
        """
        Sets the excluded_subtree of this NameConstraint.
        A list that contains excluded (or prohibited) namespaces. If you have a name constraint with no permitted namespaces, you must specify at least one excluded namespace.


        :param excluded_subtree: The excluded_subtree of this NameConstraint.
        :type: list[oci.certificates_management.models.NameConstraintSubtreeNode]
        """
        self._excluded_subtree = excluded_subtree

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
