# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateInternalOccmDemandSignalDetails(object):
    """
    An internal model to update the demand signal state.
    """

    #: A constant which can be used with the lifecycle_details property of a UpdateInternalOccmDemandSignalDetails.
    #: This constant has a value of "IN_PROGRESS"
    LIFECYCLE_DETAILS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the lifecycle_details property of a UpdateInternalOccmDemandSignalDetails.
    #: This constant has a value of "COMPLETED"
    LIFECYCLE_DETAILS_COMPLETED = "COMPLETED"

    #: A constant which can be used with the lifecycle_details property of a UpdateInternalOccmDemandSignalDetails.
    #: This constant has a value of "REJECTED"
    LIFECYCLE_DETAILS_REJECTED = "REJECTED"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateInternalOccmDemandSignalDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this UpdateInternalOccmDemandSignalDetails.
            Allowed values for this property are: "IN_PROGRESS", "COMPLETED", "REJECTED"
        :type lifecycle_details: str

        """
        self.swagger_types = {
            'lifecycle_details': 'str'
        }
        self.attribute_map = {
            'lifecycle_details': 'lifecycleDetails'
        }
        self._lifecycle_details = None

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this UpdateInternalOccmDemandSignalDetails.
        The subset of demand signal states available for operators for updating the demand signal.

        IN_PROGRESS -> Transitions the demand signal to IN_PROGRESS state.
        REJECTED -> Transitions the demand signal to REJECTED state.
        COMPLETED -> This will transition the demand signal to COMPLETED state.

        Allowed values for this property are: "IN_PROGRESS", "COMPLETED", "REJECTED"


        :return: The lifecycle_details of this UpdateInternalOccmDemandSignalDetails.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this UpdateInternalOccmDemandSignalDetails.
        The subset of demand signal states available for operators for updating the demand signal.

        IN_PROGRESS -> Transitions the demand signal to IN_PROGRESS state.
        REJECTED -> Transitions the demand signal to REJECTED state.
        COMPLETED -> This will transition the demand signal to COMPLETED state.


        :param lifecycle_details: The lifecycle_details of this UpdateInternalOccmDemandSignalDetails.
        :type: str
        """
        allowed_values = ["IN_PROGRESS", "COMPLETED", "REJECTED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_details, allowed_values):
            raise ValueError(
                f"Invalid value for `lifecycle_details`, must be None or one of {allowed_values}"
            )
        self._lifecycle_details = lifecycle_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
