# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOccCustomerDetails(object):
    """
    The details about the customer.
    """

    #: A constant which can be used with the status property of a CreateOccCustomerDetails.
    #: This constant has a value of "ENABLED"
    STATUS_ENABLED = "ENABLED"

    #: A constant which can be used with the status property of a CreateOccCustomerDetails.
    #: This constant has a value of "DISABLED"
    STATUS_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOccCustomerDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tenancy_id:
            The value to assign to the tenancy_id property of this CreateOccCustomerDetails.
        :type tenancy_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateOccCustomerDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateOccCustomerDetails.
        :type description: str

        :param status:
            The value to assign to the status property of this CreateOccCustomerDetails.
            Allowed values for this property are: "ENABLED", "DISABLED"
        :type status: str

        """
        self.swagger_types = {
            'tenancy_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'status': 'str'
        }
        self.attribute_map = {
            'tenancy_id': 'tenancyId',
            'display_name': 'displayName',
            'description': 'description',
            'status': 'status'
        }
        self._tenancy_id = None
        self._display_name = None
        self._description = None
        self._status = None

    @property
    def tenancy_id(self):
        """
        **[Required]** Gets the tenancy_id of this CreateOccCustomerDetails.
        The OCID of the tenancy belonging to the customer.


        :return: The tenancy_id of this CreateOccCustomerDetails.
        :rtype: str
        """
        return self._tenancy_id

    @tenancy_id.setter
    def tenancy_id(self, tenancy_id):
        """
        Sets the tenancy_id of this CreateOccCustomerDetails.
        The OCID of the tenancy belonging to the customer.


        :param tenancy_id: The tenancy_id of this CreateOccCustomerDetails.
        :type: str
        """
        self._tenancy_id = tenancy_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateOccCustomerDetails.
        The display name for the customer.


        :return: The display_name of this CreateOccCustomerDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateOccCustomerDetails.
        The display name for the customer.


        :param display_name: The display_name of this CreateOccCustomerDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateOccCustomerDetails.
        The description about the customer group.


        :return: The description of this CreateOccCustomerDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateOccCustomerDetails.
        The description about the customer group.


        :param description: The description of this CreateOccCustomerDetails.
        :type: str
        """
        self._description = description

    @property
    def status(self):
        """
        Gets the status of this CreateOccCustomerDetails.
        To determine whether the customer is enabled/disabled.

        Allowed values for this property are: "ENABLED", "DISABLED"


        :return: The status of this CreateOccCustomerDetails.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this CreateOccCustomerDetails.
        To determine whether the customer is enabled/disabled.


        :param status: The status of this CreateOccCustomerDetails.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            raise ValueError(
                f"Invalid value for `status`, must be None or one of {allowed_values}"
            )
        self._status = status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
