# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190111


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CostAlertSubscriptionMap(object):
    """
    The mapping of cost monitor to alert subscription along with thresholds.
    """

    #: A constant which can be used with the operator property of a CostAlertSubscriptionMap.
    #: This constant has a value of "AND"
    OPERATOR_AND = "AND"

    #: A constant which can be used with the operator property of a CostAlertSubscriptionMap.
    #: This constant has a value of "OR"
    OPERATOR_OR = "OR"

    def __init__(self, **kwargs):
        """
        Initializes a new CostAlertSubscriptionMap object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operator:
            The value to assign to the operator property of this CostAlertSubscriptionMap.
            Allowed values for this property are: "AND", "OR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operator: str

        :param threshold_absolute_value:
            The value to assign to the threshold_absolute_value property of this CostAlertSubscriptionMap.
        :type threshold_absolute_value: int

        :param threshold_relative_percent:
            The value to assign to the threshold_relative_percent property of this CostAlertSubscriptionMap.
        :type threshold_relative_percent: int

        :param cost_alert_subscription_id:
            The value to assign to the cost_alert_subscription_id property of this CostAlertSubscriptionMap.
        :type cost_alert_subscription_id: str

        """
        self.swagger_types = {
            'operator': 'str',
            'threshold_absolute_value': 'int',
            'threshold_relative_percent': 'int',
            'cost_alert_subscription_id': 'str'
        }
        self.attribute_map = {
            'operator': 'operator',
            'threshold_absolute_value': 'thresholdAbsoluteValue',
            'threshold_relative_percent': 'thresholdRelativePercent',
            'cost_alert_subscription_id': 'costAlertSubscriptionId'
        }
        self._operator = None
        self._threshold_absolute_value = None
        self._threshold_relative_percent = None
        self._cost_alert_subscription_id = None

    @property
    def operator(self):
        """
        Gets the operator of this CostAlertSubscriptionMap.
        The filter operator. Example: 'AND', 'OR'.

        Allowed values for this property are: "AND", "OR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operator of this CostAlertSubscriptionMap.
        :rtype: str
        """
        return self._operator

    @operator.setter
    def operator(self, operator):
        """
        Sets the operator of this CostAlertSubscriptionMap.
        The filter operator. Example: 'AND', 'OR'.


        :param operator: The operator of this CostAlertSubscriptionMap.
        :type: str
        """
        allowed_values = ["AND", "OR"]
        if not value_allowed_none_or_none_sentinel(operator, allowed_values):
            operator = 'UNKNOWN_ENUM_VALUE'
        self._operator = operator

    @property
    def threshold_absolute_value(self):
        """
        Gets the threshold_absolute_value of this CostAlertSubscriptionMap.
        The absolute threshold value.


        :return: The threshold_absolute_value of this CostAlertSubscriptionMap.
        :rtype: int
        """
        return self._threshold_absolute_value

    @threshold_absolute_value.setter
    def threshold_absolute_value(self, threshold_absolute_value):
        """
        Sets the threshold_absolute_value of this CostAlertSubscriptionMap.
        The absolute threshold value.


        :param threshold_absolute_value: The threshold_absolute_value of this CostAlertSubscriptionMap.
        :type: int
        """
        self._threshold_absolute_value = threshold_absolute_value

    @property
    def threshold_relative_percent(self):
        """
        Gets the threshold_relative_percent of this CostAlertSubscriptionMap.
        The relative percentage threshold value.


        :return: The threshold_relative_percent of this CostAlertSubscriptionMap.
        :rtype: int
        """
        return self._threshold_relative_percent

    @threshold_relative_percent.setter
    def threshold_relative_percent(self, threshold_relative_percent):
        """
        Sets the threshold_relative_percent of this CostAlertSubscriptionMap.
        The relative percentage threshold value.


        :param threshold_relative_percent: The threshold_relative_percent of this CostAlertSubscriptionMap.
        :type: int
        """
        self._threshold_relative_percent = threshold_relative_percent

    @property
    def cost_alert_subscription_id(self):
        """
        Gets the cost_alert_subscription_id of this CostAlertSubscriptionMap.
        The costAlertSubscription ocid which the cost monitor alert maps to.


        :return: The cost_alert_subscription_id of this CostAlertSubscriptionMap.
        :rtype: str
        """
        return self._cost_alert_subscription_id

    @cost_alert_subscription_id.setter
    def cost_alert_subscription_id(self, cost_alert_subscription_id):
        """
        Sets the cost_alert_subscription_id of this CostAlertSubscriptionMap.
        The costAlertSubscription ocid which the cost monitor alert maps to.


        :param cost_alert_subscription_id: The cost_alert_subscription_id of this CostAlertSubscriptionMap.
        :type: str
        """
        self._cost_alert_subscription_id = cost_alert_subscription_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
