# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NodeBackupConfiguration(object):
    """
    The information about the NodeBackupConfiguration.
    """

    #: A constant which can be used with the lifecycle_state property of a NodeBackupConfiguration.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a NodeBackupConfiguration.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a NodeBackupConfiguration.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a NodeBackupConfiguration.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a NodeBackupConfiguration.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a NodeBackupConfiguration.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new NodeBackupConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this NodeBackupConfiguration.
        :type id: str

        :param bds_instance_id:
            The value to assign to the bds_instance_id property of this NodeBackupConfiguration.
        :type bds_instance_id: str

        :param display_name:
            The value to assign to the display_name property of this NodeBackupConfiguration.
        :type display_name: str

        :param level_type_details:
            The value to assign to the level_type_details property of this NodeBackupConfiguration.
        :type level_type_details: oci.bds.models.LevelTypeDetails

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this NodeBackupConfiguration.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this NodeBackupConfiguration.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this NodeBackupConfiguration.
        :type time_updated: datetime

        :param timezone:
            The value to assign to the timezone property of this NodeBackupConfiguration.
        :type timezone: str

        :param schedule:
            The value to assign to the schedule property of this NodeBackupConfiguration.
        :type schedule: str

        :param number_of_backups_to_retain:
            The value to assign to the number_of_backups_to_retain property of this NodeBackupConfiguration.
        :type number_of_backups_to_retain: int

        :param backup_type:
            The value to assign to the backup_type property of this NodeBackupConfiguration.
        :type backup_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'bds_instance_id': 'str',
            'display_name': 'str',
            'level_type_details': 'LevelTypeDetails',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'timezone': 'str',
            'schedule': 'str',
            'number_of_backups_to_retain': 'int',
            'backup_type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'bds_instance_id': 'bdsInstanceId',
            'display_name': 'displayName',
            'level_type_details': 'levelTypeDetails',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'timezone': 'timezone',
            'schedule': 'schedule',
            'number_of_backups_to_retain': 'numberOfBackupsToRetain',
            'backup_type': 'backupType'
        }
        self._id = None
        self._bds_instance_id = None
        self._display_name = None
        self._level_type_details = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._timezone = None
        self._schedule = None
        self._number_of_backups_to_retain = None
        self._backup_type = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this NodeBackupConfiguration.
        The unique identifier for the NodeBackupConfiguration.


        :return: The id of this NodeBackupConfiguration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NodeBackupConfiguration.
        The unique identifier for the NodeBackupConfiguration.


        :param id: The id of this NodeBackupConfiguration.
        :type: str
        """
        self._id = id

    @property
    def bds_instance_id(self):
        """
        **[Required]** Gets the bds_instance_id of this NodeBackupConfiguration.
        The OCID of the bdsInstance which is the parent resource id.


        :return: The bds_instance_id of this NodeBackupConfiguration.
        :rtype: str
        """
        return self._bds_instance_id

    @bds_instance_id.setter
    def bds_instance_id(self, bds_instance_id):
        """
        Sets the bds_instance_id of this NodeBackupConfiguration.
        The OCID of the bdsInstance which is the parent resource id.


        :param bds_instance_id: The bds_instance_id of this NodeBackupConfiguration.
        :type: str
        """
        self._bds_instance_id = bds_instance_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this NodeBackupConfiguration.
        A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.


        :return: The display_name of this NodeBackupConfiguration.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this NodeBackupConfiguration.
        A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.


        :param display_name: The display_name of this NodeBackupConfiguration.
        :type: str
        """
        self._display_name = display_name

    @property
    def level_type_details(self):
        """
        **[Required]** Gets the level_type_details of this NodeBackupConfiguration.

        :return: The level_type_details of this NodeBackupConfiguration.
        :rtype: oci.bds.models.LevelTypeDetails
        """
        return self._level_type_details

    @level_type_details.setter
    def level_type_details(self, level_type_details):
        """
        Sets the level_type_details of this NodeBackupConfiguration.

        :param level_type_details: The level_type_details of this NodeBackupConfiguration.
        :type: oci.bds.models.LevelTypeDetails
        """
        self._level_type_details = level_type_details

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this NodeBackupConfiguration.
        The state of the NodeBackupConfiguration.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this NodeBackupConfiguration.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this NodeBackupConfiguration.
        The state of the NodeBackupConfiguration.


        :param lifecycle_state: The lifecycle_state of this NodeBackupConfiguration.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this NodeBackupConfiguration.
        The time the NodeBackupConfiguration was created, shown as an RFC 3339 formatted datetime string.


        :return: The time_created of this NodeBackupConfiguration.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this NodeBackupConfiguration.
        The time the NodeBackupConfiguration was created, shown as an RFC 3339 formatted datetime string.


        :param time_created: The time_created of this NodeBackupConfiguration.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this NodeBackupConfiguration.
        The time the NodeBackupConfiguration was updated, shown as an RFC 3339 formatted datetime string.


        :return: The time_updated of this NodeBackupConfiguration.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this NodeBackupConfiguration.
        The time the NodeBackupConfiguration was updated, shown as an RFC 3339 formatted datetime string.


        :param time_updated: The time_updated of this NodeBackupConfiguration.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def timezone(self):
        """
        **[Required]** Gets the timezone of this NodeBackupConfiguration.
        The time zone of the execution schedule, in IANA time zone database name format


        :return: The timezone of this NodeBackupConfiguration.
        :rtype: str
        """
        return self._timezone

    @timezone.setter
    def timezone(self, timezone):
        """
        Sets the timezone of this NodeBackupConfiguration.
        The time zone of the execution schedule, in IANA time zone database name format


        :param timezone: The timezone of this NodeBackupConfiguration.
        :type: str
        """
        self._timezone = timezone

    @property
    def schedule(self):
        """
        **[Required]** Gets the schedule of this NodeBackupConfiguration.
        Day/time recurrence (specified following RFC 5545) at which to trigger the backup process. Currently only DAILY, WEEKLY and MONTHLY frequency is supported. Days of the week are specified using BYDAY field. Time of the day is specified using BYHOUR. Other fields are not supported.


        :return: The schedule of this NodeBackupConfiguration.
        :rtype: str
        """
        return self._schedule

    @schedule.setter
    def schedule(self, schedule):
        """
        Sets the schedule of this NodeBackupConfiguration.
        Day/time recurrence (specified following RFC 5545) at which to trigger the backup process. Currently only DAILY, WEEKLY and MONTHLY frequency is supported. Days of the week are specified using BYDAY field. Time of the day is specified using BYHOUR. Other fields are not supported.


        :param schedule: The schedule of this NodeBackupConfiguration.
        :type: str
        """
        self._schedule = schedule

    @property
    def number_of_backups_to_retain(self):
        """
        **[Required]** Gets the number_of_backups_to_retain of this NodeBackupConfiguration.
        Number of backup copies to retain.


        :return: The number_of_backups_to_retain of this NodeBackupConfiguration.
        :rtype: int
        """
        return self._number_of_backups_to_retain

    @number_of_backups_to_retain.setter
    def number_of_backups_to_retain(self, number_of_backups_to_retain):
        """
        Sets the number_of_backups_to_retain of this NodeBackupConfiguration.
        Number of backup copies to retain.


        :param number_of_backups_to_retain: The number_of_backups_to_retain of this NodeBackupConfiguration.
        :type: int
        """
        self._number_of_backups_to_retain = number_of_backups_to_retain

    @property
    def backup_type(self):
        """
        Gets the backup_type of this NodeBackupConfiguration.
        Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.


        :return: The backup_type of this NodeBackupConfiguration.
        :rtype: str
        """
        return self._backup_type

    @backup_type.setter
    def backup_type(self, backup_type):
        """
        Sets the backup_type of this NodeBackupConfiguration.
        Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.


        :param backup_type: The backup_type of this NodeBackupConfiguration.
        :type: str
        """
        self._backup_type = backup_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
