# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostCertDetails(object):
    """
    Details about the host and corresponding certificate.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HostCertDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param host_name:
            The value to assign to the host_name property of this HostCertDetails.
        :type host_name: str

        :param certificate:
            The value to assign to the certificate property of this HostCertDetails.
        :type certificate: str

        :param private_key:
            The value to assign to the private_key property of this HostCertDetails.
        :type private_key: str

        """
        self.swagger_types = {
            'host_name': 'str',
            'certificate': 'str',
            'private_key': 'str'
        }
        self.attribute_map = {
            'host_name': 'hostName',
            'certificate': 'certificate',
            'private_key': 'privateKey'
        }
        self._host_name = None
        self._certificate = None
        self._private_key = None

    @property
    def host_name(self):
        """
        **[Required]** Gets the host_name of this HostCertDetails.
        Fully qualified domain name (FQDN) of the host


        :return: The host_name of this HostCertDetails.
        :rtype: str
        """
        return self._host_name

    @host_name.setter
    def host_name(self, host_name):
        """
        Sets the host_name of this HostCertDetails.
        Fully qualified domain name (FQDN) of the host


        :param host_name: The host_name of this HostCertDetails.
        :type: str
        """
        self._host_name = host_name

    @property
    def certificate(self):
        """
        **[Required]** Gets the certificate of this HostCertDetails.
        Certificate value in string format


        :return: The certificate of this HostCertDetails.
        :rtype: str
        """
        return self._certificate

    @certificate.setter
    def certificate(self, certificate):
        """
        Sets the certificate of this HostCertDetails.
        Certificate value in string format


        :param certificate: The certificate of this HostCertDetails.
        :type: str
        """
        self._certificate = certificate

    @property
    def private_key(self):
        """
        **[Required]** Gets the private_key of this HostCertDetails.
        Private key of the provided certificate


        :return: The private_key of this HostCertDetails.
        :rtype: str
        """
        return self._private_key

    @private_key.setter
    def private_key(self, private_key):
        """
        Sets the private_key of this HostCertDetails.
        Private key of the provided certificate


        :param private_key: The private_key of this HostCertDetails.
        :type: str
        """
        self._private_key = private_key

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
