# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CapacityAvailability(object):
    """
    Information about the available capacity for a shape.
    """

    #: A constant which can be used with the availability_status property of a CapacityAvailability.
    #: This constant has a value of "OUT_OF_HOST_CAPACITY"
    AVAILABILITY_STATUS_OUT_OF_HOST_CAPACITY = "OUT_OF_HOST_CAPACITY"

    #: A constant which can be used with the availability_status property of a CapacityAvailability.
    #: This constant has a value of "HARDWARE_NOT_SUPPORTED"
    AVAILABILITY_STATUS_HARDWARE_NOT_SUPPORTED = "HARDWARE_NOT_SUPPORTED"

    #: A constant which can be used with the availability_status property of a CapacityAvailability.
    #: This constant has a value of "AVAILABLE"
    AVAILABILITY_STATUS_AVAILABLE = "AVAILABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new CapacityAvailability object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param availability_status:
            The value to assign to the availability_status property of this CapacityAvailability.
            Allowed values for this property are: "OUT_OF_HOST_CAPACITY", "HARDWARE_NOT_SUPPORTED", "AVAILABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type availability_status: str

        :param available_count:
            The value to assign to the available_count property of this CapacityAvailability.
        :type available_count: int

        """
        self.swagger_types = {
            'availability_status': 'str',
            'available_count': 'int'
        }
        self.attribute_map = {
            'availability_status': 'availabilityStatus',
            'available_count': 'availableCount'
        }
        self._availability_status = None
        self._available_count = None

    @property
    def availability_status(self):
        """
        **[Required]** Gets the availability_status of this CapacityAvailability.
        A flag denoting whether capacity is available.

        Allowed values for this property are: "OUT_OF_HOST_CAPACITY", "HARDWARE_NOT_SUPPORTED", "AVAILABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The availability_status of this CapacityAvailability.
        :rtype: str
        """
        return self._availability_status

    @availability_status.setter
    def availability_status(self, availability_status):
        """
        Sets the availability_status of this CapacityAvailability.
        A flag denoting whether capacity is available.


        :param availability_status: The availability_status of this CapacityAvailability.
        :type: str
        """
        allowed_values = ["OUT_OF_HOST_CAPACITY", "HARDWARE_NOT_SUPPORTED", "AVAILABLE"]
        if not value_allowed_none_or_none_sentinel(availability_status, allowed_values):
            availability_status = 'UNKNOWN_ENUM_VALUE'
        self._availability_status = availability_status

    @property
    def available_count(self):
        """
        **[Required]** Gets the available_count of this CapacityAvailability.
        The total number of new cluster nodes that can be created with the specified shape configuration.


        :return: The available_count of this CapacityAvailability.
        :rtype: int
        """
        return self._available_count

    @available_count.setter
    def available_count(self, available_count):
        """
        Sets the available_count of this CapacityAvailability.
        The total number of new cluster nodes that can be created with the specified shape configuration.


        :param available_count: The available_count of this CapacityAvailability.
        :type: int
        """
        self._available_count = available_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
