# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531

from .software_update import SoftwareUpdate
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BdsSoftwareUpdate(SoftwareUpdate):
    """
    Details about the given BDS type of software update. Previously known as Micro Service Patch.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BdsSoftwareUpdate object with values from keyword arguments. The default value of the :py:attr:`~oci.bds.models.BdsSoftwareUpdate.software_update_type` attribute
        of this class is ``BDS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param software_update_key:
            The value to assign to the software_update_key property of this BdsSoftwareUpdate.
        :type software_update_key: str

        :param software_update_version:
            The value to assign to the software_update_version property of this BdsSoftwareUpdate.
        :type software_update_version: str

        :param time_released:
            The value to assign to the time_released property of this BdsSoftwareUpdate.
        :type time_released: datetime

        :param software_update_type:
            The value to assign to the software_update_type property of this BdsSoftwareUpdate.
            Allowed values for this property are: "BDS"
        :type software_update_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this BdsSoftwareUpdate.
            Allowed values for this property are: "WAITING", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELED"
        :type lifecycle_state: str

        :param time_due:
            The value to assign to the time_due property of this BdsSoftwareUpdate.
        :type time_due: datetime

        """
        self.swagger_types = {
            'software_update_key': 'str',
            'software_update_version': 'str',
            'time_released': 'datetime',
            'software_update_type': 'str',
            'lifecycle_state': 'str',
            'time_due': 'datetime'
        }
        self.attribute_map = {
            'software_update_key': 'softwareUpdateKey',
            'software_update_version': 'softwareUpdateVersion',
            'time_released': 'timeReleased',
            'software_update_type': 'softwareUpdateType',
            'lifecycle_state': 'lifecycleState',
            'time_due': 'timeDue'
        }
        self._software_update_key = None
        self._software_update_version = None
        self._time_released = None
        self._software_update_type = None
        self._lifecycle_state = None
        self._time_due = None
        self._software_update_type = 'BDS'

    @property
    def time_due(self):
        """
        **[Required]** Gets the time_due of this BdsSoftwareUpdate.
        The due date for the software update. Big Data Service will be updated automatically after this date.


        :return: The time_due of this BdsSoftwareUpdate.
        :rtype: datetime
        """
        return self._time_due

    @time_due.setter
    def time_due(self, time_due):
        """
        Sets the time_due of this BdsSoftwareUpdate.
        The due date for the software update. Big Data Service will be updated automatically after this date.


        :param time_due: The time_due of this BdsSoftwareUpdate.
        :type: datetime
        """
        self._time_due = time_due

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
