# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScheduledQueryProcessingConfig(object):
    """
    Definition of the scheduled query processing configuration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ScheduledQueryProcessingConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param streaming:
            The value to assign to the streaming property of this ScheduledQueryProcessingConfig.
        :type streaming: oci.apm_traces.models.Streaming

        :param object_storage:
            The value to assign to the object_storage property of this ScheduledQueryProcessingConfig.
        :type object_storage: oci.apm_traces.models.ObjectStorage

        :param custom_metric:
            The value to assign to the custom_metric property of this ScheduledQueryProcessingConfig.
        :type custom_metric: oci.apm_traces.models.CustomMetric

        """
        self.swagger_types = {
            'streaming': 'Streaming',
            'object_storage': 'ObjectStorage',
            'custom_metric': 'CustomMetric'
        }
        self.attribute_map = {
            'streaming': 'streaming',
            'object_storage': 'objectStorage',
            'custom_metric': 'customMetric'
        }
        self._streaming = None
        self._object_storage = None
        self._custom_metric = None

    @property
    def streaming(self):
        """
        Gets the streaming of this ScheduledQueryProcessingConfig.

        :return: The streaming of this ScheduledQueryProcessingConfig.
        :rtype: oci.apm_traces.models.Streaming
        """
        return self._streaming

    @streaming.setter
    def streaming(self, streaming):
        """
        Sets the streaming of this ScheduledQueryProcessingConfig.

        :param streaming: The streaming of this ScheduledQueryProcessingConfig.
        :type: oci.apm_traces.models.Streaming
        """
        self._streaming = streaming

    @property
    def object_storage(self):
        """
        Gets the object_storage of this ScheduledQueryProcessingConfig.

        :return: The object_storage of this ScheduledQueryProcessingConfig.
        :rtype: oci.apm_traces.models.ObjectStorage
        """
        return self._object_storage

    @object_storage.setter
    def object_storage(self, object_storage):
        """
        Sets the object_storage of this ScheduledQueryProcessingConfig.

        :param object_storage: The object_storage of this ScheduledQueryProcessingConfig.
        :type: oci.apm_traces.models.ObjectStorage
        """
        self._object_storage = object_storage

    @property
    def custom_metric(self):
        """
        Gets the custom_metric of this ScheduledQueryProcessingConfig.

        :return: The custom_metric of this ScheduledQueryProcessingConfig.
        :rtype: oci.apm_traces.models.CustomMetric
        """
        return self._custom_metric

    @custom_metric.setter
    def custom_metric(self, custom_metric):
        """
        Sets the custom_metric of this ScheduledQueryProcessingConfig.

        :param custom_metric: The custom_metric of this ScheduledQueryProcessingConfig.
        :type: oci.apm_traces.models.CustomMetric
        """
        self._custom_metric = custom_metric

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
