# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkUpdateAttributeDetail(object):
    """
    Object that contains the details about a single attribute in the bulk request for which properties are to be updated.
    """

    #: A constant which can be used with the unit property of a BulkUpdateAttributeDetail.
    #: This constant has a value of "NONE"
    UNIT_NONE = "NONE"

    #: A constant which can be used with the unit property of a BulkUpdateAttributeDetail.
    #: This constant has a value of "EPOCH_TIME_MS"
    UNIT_EPOCH_TIME_MS = "EPOCH_TIME_MS"

    #: A constant which can be used with the unit property of a BulkUpdateAttributeDetail.
    #: This constant has a value of "BYTES"
    UNIT_BYTES = "BYTES"

    #: A constant which can be used with the unit property of a BulkUpdateAttributeDetail.
    #: This constant has a value of "COUNT"
    UNIT_COUNT = "COUNT"

    #: A constant which can be used with the unit property of a BulkUpdateAttributeDetail.
    #: This constant has a value of "DURATION_MS"
    UNIT_DURATION_MS = "DURATION_MS"

    #: A constant which can be used with the unit property of a BulkUpdateAttributeDetail.
    #: This constant has a value of "TRACE_STATUS"
    UNIT_TRACE_STATUS = "TRACE_STATUS"

    #: A constant which can be used with the unit property of a BulkUpdateAttributeDetail.
    #: This constant has a value of "PERCENTAGE"
    UNIT_PERCENTAGE = "PERCENTAGE"

    #: A constant which can be used with the attribute_name_space property of a BulkUpdateAttributeDetail.
    #: This constant has a value of "TRACES"
    ATTRIBUTE_NAME_SPACE_TRACES = "TRACES"

    #: A constant which can be used with the attribute_name_space property of a BulkUpdateAttributeDetail.
    #: This constant has a value of "SYNTHETIC"
    ATTRIBUTE_NAME_SPACE_SYNTHETIC = "SYNTHETIC"

    #: A constant which can be used with the attribute_name_space property of a BulkUpdateAttributeDetail.
    #: This constant has a value of "LOGS"
    ATTRIBUTE_NAME_SPACE_LOGS = "LOGS"

    def __init__(self, **kwargs):
        """
        Initializes a new BulkUpdateAttributeDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attribute_name:
            The value to assign to the attribute_name property of this BulkUpdateAttributeDetail.
        :type attribute_name: str

        :param unit:
            The value to assign to the unit property of this BulkUpdateAttributeDetail.
            Allowed values for this property are: "NONE", "EPOCH_TIME_MS", "BYTES", "COUNT", "DURATION_MS", "TRACE_STATUS", "PERCENTAGE"
        :type unit: str

        :param attribute_name_space:
            The value to assign to the attribute_name_space property of this BulkUpdateAttributeDetail.
            Allowed values for this property are: "TRACES", "SYNTHETIC", "LOGS"
        :type attribute_name_space: str

        """
        self.swagger_types = {
            'attribute_name': 'str',
            'unit': 'str',
            'attribute_name_space': 'str'
        }
        self.attribute_map = {
            'attribute_name': 'attributeName',
            'unit': 'unit',
            'attribute_name_space': 'attributeNameSpace'
        }
        self._attribute_name = None
        self._unit = None
        self._attribute_name_space = None

    @property
    def attribute_name(self):
        """
        **[Required]** Gets the attribute_name of this BulkUpdateAttributeDetail.
        Name of the attribute for which notes are to be updated.


        :return: The attribute_name of this BulkUpdateAttributeDetail.
        :rtype: str
        """
        return self._attribute_name

    @attribute_name.setter
    def attribute_name(self, attribute_name):
        """
        Sets the attribute_name of this BulkUpdateAttributeDetail.
        Name of the attribute for which notes are to be updated.


        :param attribute_name: The attribute_name of this BulkUpdateAttributeDetail.
        :type: str
        """
        self._attribute_name = attribute_name

    @property
    def unit(self):
        """
        Gets the unit of this BulkUpdateAttributeDetail.
        Unit of the attribute to be updated.  If unit is not specified, it defaults to NONE.

        Allowed values for this property are: "NONE", "EPOCH_TIME_MS", "BYTES", "COUNT", "DURATION_MS", "TRACE_STATUS", "PERCENTAGE"


        :return: The unit of this BulkUpdateAttributeDetail.
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """
        Sets the unit of this BulkUpdateAttributeDetail.
        Unit of the attribute to be updated.  If unit is not specified, it defaults to NONE.


        :param unit: The unit of this BulkUpdateAttributeDetail.
        :type: str
        """
        allowed_values = ["NONE", "EPOCH_TIME_MS", "BYTES", "COUNT", "DURATION_MS", "TRACE_STATUS", "PERCENTAGE"]
        if not value_allowed_none_or_none_sentinel(unit, allowed_values):
            raise ValueError(
                f"Invalid value for `unit`, must be None or one of {allowed_values}"
            )
        self._unit = unit

    @property
    def attribute_name_space(self):
        """
        Gets the attribute_name_space of this BulkUpdateAttributeDetail.
        Namespace of the attribute for which the properties are to be updated.

        Allowed values for this property are: "TRACES", "SYNTHETIC", "LOGS"


        :return: The attribute_name_space of this BulkUpdateAttributeDetail.
        :rtype: str
        """
        return self._attribute_name_space

    @attribute_name_space.setter
    def attribute_name_space(self, attribute_name_space):
        """
        Sets the attribute_name_space of this BulkUpdateAttributeDetail.
        Namespace of the attribute for which the properties are to be updated.


        :param attribute_name_space: The attribute_name_space of this BulkUpdateAttributeDetail.
        :type: str
        """
        allowed_values = ["TRACES", "SYNTHETIC", "LOGS"]
        if not value_allowed_none_or_none_sentinel(attribute_name_space, allowed_values):
            raise ValueError(
                f"Invalid value for `attribute_name_space`, must be None or one of {allowed_values}"
            )
        self._attribute_name_space = attribute_name_space

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
