# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AttributeMetadata(object):
    """
    Definition of the attribute metadata.
    """

    #: A constant which can be used with the attribute_type property of a AttributeMetadata.
    #: This constant has a value of "STRING"
    ATTRIBUTE_TYPE_STRING = "STRING"

    #: A constant which can be used with the attribute_type property of a AttributeMetadata.
    #: This constant has a value of "NUMERIC"
    ATTRIBUTE_TYPE_NUMERIC = "NUMERIC"

    #: A constant which can be used with the attribute_unit property of a AttributeMetadata.
    #: This constant has a value of "EPOCH_TIME_MS"
    ATTRIBUTE_UNIT_EPOCH_TIME_MS = "EPOCH_TIME_MS"

    #: A constant which can be used with the attribute_unit property of a AttributeMetadata.
    #: This constant has a value of "BYTES"
    ATTRIBUTE_UNIT_BYTES = "BYTES"

    #: A constant which can be used with the attribute_unit property of a AttributeMetadata.
    #: This constant has a value of "COUNT"
    ATTRIBUTE_UNIT_COUNT = "COUNT"

    #: A constant which can be used with the attribute_unit property of a AttributeMetadata.
    #: This constant has a value of "DURATION_MS"
    ATTRIBUTE_UNIT_DURATION_MS = "DURATION_MS"

    #: A constant which can be used with the attribute_unit property of a AttributeMetadata.
    #: This constant has a value of "PERCENTAGE"
    ATTRIBUTE_UNIT_PERCENTAGE = "PERCENTAGE"

    #: A constant which can be used with the attribute_unit property of a AttributeMetadata.
    #: This constant has a value of "NONE"
    ATTRIBUTE_UNIT_NONE = "NONE"

    def __init__(self, **kwargs):
        """
        Initializes a new AttributeMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attribute_type:
            The value to assign to the attribute_type property of this AttributeMetadata.
            Allowed values for this property are: "STRING", "NUMERIC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type attribute_type: str

        :param attribute_unit:
            The value to assign to the attribute_unit property of this AttributeMetadata.
            Allowed values for this property are: "EPOCH_TIME_MS", "BYTES", "COUNT", "DURATION_MS", "PERCENTAGE", "NONE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type attribute_unit: str

        """
        self.swagger_types = {
            'attribute_type': 'str',
            'attribute_unit': 'str'
        }
        self.attribute_map = {
            'attribute_type': 'attributeType',
            'attribute_unit': 'attributeUnit'
        }
        self._attribute_type = None
        self._attribute_unit = None

    @property
    def attribute_type(self):
        """
        Gets the attribute_type of this AttributeMetadata.
        Type associated with the attribute key.

        Allowed values for this property are: "STRING", "NUMERIC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The attribute_type of this AttributeMetadata.
        :rtype: str
        """
        return self._attribute_type

    @attribute_type.setter
    def attribute_type(self, attribute_type):
        """
        Sets the attribute_type of this AttributeMetadata.
        Type associated with the attribute key.


        :param attribute_type: The attribute_type of this AttributeMetadata.
        :type: str
        """
        allowed_values = ["STRING", "NUMERIC"]
        if not value_allowed_none_or_none_sentinel(attribute_type, allowed_values):
            attribute_type = 'UNKNOWN_ENUM_VALUE'
        self._attribute_type = attribute_type

    @property
    def attribute_unit(self):
        """
        Gets the attribute_unit of this AttributeMetadata.
        Unit associated with the attribute key.  If unit is not specified, it defaults to NONE.

        Allowed values for this property are: "EPOCH_TIME_MS", "BYTES", "COUNT", "DURATION_MS", "PERCENTAGE", "NONE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The attribute_unit of this AttributeMetadata.
        :rtype: str
        """
        return self._attribute_unit

    @attribute_unit.setter
    def attribute_unit(self, attribute_unit):
        """
        Sets the attribute_unit of this AttributeMetadata.
        Unit associated with the attribute key.  If unit is not specified, it defaults to NONE.


        :param attribute_unit: The attribute_unit of this AttributeMetadata.
        :type: str
        """
        allowed_values = ["EPOCH_TIME_MS", "BYTES", "COUNT", "DURATION_MS", "PERCENTAGE", "NONE"]
        if not value_allowed_none_or_none_sentinel(attribute_unit, allowed_values):
            attribute_unit = 'UNKNOWN_ENUM_VALUE'
        self._attribute_unit = attribute_unit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
