# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125

from .video_feature import VideoFeature
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VideoFaceDetectionFeature(VideoFeature):
    """
    Video face detection feature
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VideoFaceDetectionFeature object with values from keyword arguments. The default value of the :py:attr:`~oci.ai_vision.models.VideoFaceDetectionFeature.feature_type` attribute
        of this class is ``FACE_DETECTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param feature_type:
            The value to assign to the feature_type property of this VideoFaceDetectionFeature.
            Allowed values for this property are: "LABEL_DETECTION", "OBJECT_DETECTION", "TEXT_DETECTION", "FACE_DETECTION", "OBJECT_TRACKING"
        :type feature_type: str

        :param max_results:
            The value to assign to the max_results property of this VideoFaceDetectionFeature.
        :type max_results: int

        :param is_landmark_required:
            The value to assign to the is_landmark_required property of this VideoFaceDetectionFeature.
        :type is_landmark_required: bool

        :param min_confidence:
            The value to assign to the min_confidence property of this VideoFaceDetectionFeature.
        :type min_confidence: float

        """
        self.swagger_types = {
            'feature_type': 'str',
            'max_results': 'int',
            'is_landmark_required': 'bool',
            'min_confidence': 'float'
        }
        self.attribute_map = {
            'feature_type': 'featureType',
            'max_results': 'maxResults',
            'is_landmark_required': 'isLandmarkRequired',
            'min_confidence': 'minConfidence'
        }
        self._feature_type = None
        self._max_results = None
        self._is_landmark_required = None
        self._min_confidence = None
        self._feature_type = 'FACE_DETECTION'

    @property
    def max_results(self):
        """
        Gets the max_results of this VideoFaceDetectionFeature.
        The maximum number of results per frame to return.


        :return: The max_results of this VideoFaceDetectionFeature.
        :rtype: int
        """
        return self._max_results

    @max_results.setter
    def max_results(self, max_results):
        """
        Sets the max_results of this VideoFaceDetectionFeature.
        The maximum number of results per frame to return.


        :param max_results: The max_results of this VideoFaceDetectionFeature.
        :type: int
        """
        self._max_results = max_results

    @property
    def is_landmark_required(self):
        """
        Gets the is_landmark_required of this VideoFaceDetectionFeature.
        Whether or not return face landmarks.


        :return: The is_landmark_required of this VideoFaceDetectionFeature.
        :rtype: bool
        """
        return self._is_landmark_required

    @is_landmark_required.setter
    def is_landmark_required(self, is_landmark_required):
        """
        Sets the is_landmark_required of this VideoFaceDetectionFeature.
        Whether or not return face landmarks.


        :param is_landmark_required: The is_landmark_required of this VideoFaceDetectionFeature.
        :type: bool
        """
        self._is_landmark_required = is_landmark_required

    @property
    def min_confidence(self):
        """
        Gets the min_confidence of this VideoFaceDetectionFeature.
        The minimum confidence score, between 0 and 1,
        when the value is set, results with lower confidence will not be returned.


        :return: The min_confidence of this VideoFaceDetectionFeature.
        :rtype: float
        """
        return self._min_confidence

    @min_confidence.setter
    def min_confidence(self, min_confidence):
        """
        Sets the min_confidence of this VideoFaceDetectionFeature.
        The minimum confidence score, between 0 and 1,
        when the value is set, results with lower confidence will not be returned.


        :param min_confidence: The min_confidence of this VideoFaceDetectionFeature.
        :type: float
        """
        self._min_confidence = min_confidence

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
