# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StreamGroupSummary(object):
    """
    Summary for a Stream Group
    """

    def __init__(self, **kwargs):
        """
        Initializes a new StreamGroupSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this StreamGroupSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this StreamGroupSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this StreamGroupSummary.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this StreamGroupSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this StreamGroupSummary.
        :type time_updated: datetime

        :param is_enabled:
            The value to assign to the is_enabled property of this StreamGroupSummary.
        :type is_enabled: bool

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this StreamGroupSummary.
        :type lifecycle_state: str

        :param stream_source_ids:
            The value to assign to the stream_source_ids property of this StreamGroupSummary.
        :type stream_source_ids: list[str]

        :param stream_overlaps:
            The value to assign to the stream_overlaps property of this StreamGroupSummary.
        :type stream_overlaps: list[oci.ai_vision.models.StreamGroupOverlap]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this StreamGroupSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this StreamGroupSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this StreamGroupSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'is_enabled': 'bool',
            'lifecycle_state': 'str',
            'stream_source_ids': 'list[str]',
            'stream_overlaps': 'list[StreamGroupOverlap]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'is_enabled': 'isEnabled',
            'lifecycle_state': 'lifecycleState',
            'stream_source_ids': 'streamSourceIds',
            'stream_overlaps': 'streamOverlaps',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._time_created = None
        self._time_updated = None
        self._is_enabled = None
        self._lifecycle_state = None
        self._stream_source_ids = None
        self._stream_overlaps = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this StreamGroupSummary.
        `OCID`__ of the streamGroup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this StreamGroupSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this StreamGroupSummary.
        `OCID`__ of the streamGroup.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this StreamGroupSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this StreamGroupSummary.
        `OCID`__ of compartment

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this StreamGroupSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this StreamGroupSummary.
        `OCID`__ of compartment

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this StreamGroupSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this StreamGroupSummary.
        A human-friendly name for the streamGroup.


        :return: The display_name of this StreamGroupSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this StreamGroupSummary.
        A human-friendly name for the streamGroup.


        :param display_name: The display_name of this StreamGroupSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        Gets the time_created of this StreamGroupSummary.
        When the streamGroup was created, as an RFC3339 datetime string.


        :return: The time_created of this StreamGroupSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this StreamGroupSummary.
        When the streamGroup was created, as an RFC3339 datetime string.


        :param time_created: The time_created of this StreamGroupSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this StreamGroupSummary.
        When the streamGroup was updated, as an RFC3339 datetime string.


        :return: The time_updated of this StreamGroupSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this StreamGroupSummary.
        When the streamGroup was updated, as an RFC3339 datetime string.


        :param time_updated: The time_updated of this StreamGroupSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this StreamGroupSummary.
        Stream


        :return: The is_enabled of this StreamGroupSummary.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this StreamGroupSummary.
        Stream


        :param is_enabled: The is_enabled of this StreamGroupSummary.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this StreamGroupSummary.
        The current state of the streamGroup.


        :return: The lifecycle_state of this StreamGroupSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this StreamGroupSummary.
        The current state of the streamGroup.


        :param lifecycle_state: The lifecycle_state of this StreamGroupSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def stream_source_ids(self):
        """
        Gets the stream_source_ids of this StreamGroupSummary.
        List of streamSource OCIDs associated with the stream group


        :return: The stream_source_ids of this StreamGroupSummary.
        :rtype: list[str]
        """
        return self._stream_source_ids

    @stream_source_ids.setter
    def stream_source_ids(self, stream_source_ids):
        """
        Sets the stream_source_ids of this StreamGroupSummary.
        List of streamSource OCIDs associated with the stream group


        :param stream_source_ids: The stream_source_ids of this StreamGroupSummary.
        :type: list[str]
        """
        self._stream_source_ids = stream_source_ids

    @property
    def stream_overlaps(self):
        """
        Gets the stream_overlaps of this StreamGroupSummary.
        List of streamSource OCIDs where the streamSource overlaps in field of view.


        :return: The stream_overlaps of this StreamGroupSummary.
        :rtype: list[oci.ai_vision.models.StreamGroupOverlap]
        """
        return self._stream_overlaps

    @stream_overlaps.setter
    def stream_overlaps(self, stream_overlaps):
        """
        Sets the stream_overlaps of this StreamGroupSummary.
        List of streamSource OCIDs where the streamSource overlaps in field of view.


        :param stream_overlaps: The stream_overlaps of this StreamGroupSummary.
        :type: list[oci.ai_vision.models.StreamGroupOverlap]
        """
        self._stream_overlaps = stream_overlaps

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this StreamGroupSummary.
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only.
        For example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this StreamGroupSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this StreamGroupSummary.
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only.
        For example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this StreamGroupSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this StreamGroupSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this StreamGroupSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this StreamGroupSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this StreamGroupSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this StreamGroupSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        For example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this StreamGroupSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this StreamGroupSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        For example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this StreamGroupSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
