# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateStreamGroupDetails(object):
    """
    The information needed to create a stream group
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateStreamGroupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateStreamGroupDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateStreamGroupDetails.
        :type display_name: str

        :param is_enabled:
            The value to assign to the is_enabled property of this CreateStreamGroupDetails.
        :type is_enabled: bool

        :param stream_source_ids:
            The value to assign to the stream_source_ids property of this CreateStreamGroupDetails.
        :type stream_source_ids: list[str]

        :param stream_overlaps:
            The value to assign to the stream_overlaps property of this CreateStreamGroupDetails.
        :type stream_overlaps: list[oci.ai_vision.models.StreamGroupOverlap]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateStreamGroupDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateStreamGroupDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'is_enabled': 'bool',
            'stream_source_ids': 'list[str]',
            'stream_overlaps': 'list[StreamGroupOverlap]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'is_enabled': 'isEnabled',
            'stream_source_ids': 'streamSourceIds',
            'stream_overlaps': 'streamOverlaps',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._is_enabled = None
        self._stream_source_ids = None
        self._stream_overlaps = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateStreamGroupDetails.
        `OCID`__ of compartment

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateStreamGroupDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateStreamGroupDetails.
        `OCID`__ of compartment

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateStreamGroupDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateStreamGroupDetails.
        A human-friendly name for the streamGroup.


        :return: The display_name of this CreateStreamGroupDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateStreamGroupDetails.
        A human-friendly name for the streamGroup.


        :param display_name: The display_name of this CreateStreamGroupDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this CreateStreamGroupDetails.
        Stream


        :return: The is_enabled of this CreateStreamGroupDetails.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this CreateStreamGroupDetails.
        Stream


        :param is_enabled: The is_enabled of this CreateStreamGroupDetails.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def stream_source_ids(self):
        """
        Gets the stream_source_ids of this CreateStreamGroupDetails.
        List of streamSource OCIDs associated with the stream group


        :return: The stream_source_ids of this CreateStreamGroupDetails.
        :rtype: list[str]
        """
        return self._stream_source_ids

    @stream_source_ids.setter
    def stream_source_ids(self, stream_source_ids):
        """
        Sets the stream_source_ids of this CreateStreamGroupDetails.
        List of streamSource OCIDs associated with the stream group


        :param stream_source_ids: The stream_source_ids of this CreateStreamGroupDetails.
        :type: list[str]
        """
        self._stream_source_ids = stream_source_ids

    @property
    def stream_overlaps(self):
        """
        Gets the stream_overlaps of this CreateStreamGroupDetails.
        List of streamSource OCIDs where the streamSource overlaps in field of view.


        :return: The stream_overlaps of this CreateStreamGroupDetails.
        :rtype: list[oci.ai_vision.models.StreamGroupOverlap]
        """
        return self._stream_overlaps

    @stream_overlaps.setter
    def stream_overlaps(self, stream_overlaps):
        """
        Sets the stream_overlaps of this CreateStreamGroupDetails.
        List of streamSource OCIDs where the streamSource overlaps in field of view.


        :param stream_overlaps: The stream_overlaps of this CreateStreamGroupDetails.
        :type: list[oci.ai_vision.models.StreamGroupOverlap]
        """
        self._stream_overlaps = stream_overlaps

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateStreamGroupDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only.
        For example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateStreamGroupDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateStreamGroupDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only.
        For example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateStreamGroupDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateStreamGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateStreamGroupDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateStreamGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateStreamGroupDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
