# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RealtimeSessionToken(object):
    """
    The response from the realtime session token endpoint that creates the auth token to be used with the realtime speech service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RealtimeSessionToken object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param token:
            The value to assign to the token property of this RealtimeSessionToken.
        :type token: str

        :param session_id:
            The value to assign to the session_id property of this RealtimeSessionToken.
        :type session_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RealtimeSessionToken.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this RealtimeSessionToken.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this RealtimeSessionToken.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'token': 'str',
            'session_id': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'token': 'token',
            'session_id': 'sessionId',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._token = None
        self._session_id = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def token(self):
        """
        **[Required]** Gets the token of this RealtimeSessionToken.
        The session token (JWT) to be consumed by the websocket server. The token contains the session/tenant ID, as well as the expiry time.


        :return: The token of this RealtimeSessionToken.
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """
        Sets the token of this RealtimeSessionToken.
        The session token (JWT) to be consumed by the websocket server. The token contains the session/tenant ID, as well as the expiry time.


        :param token: The token of this RealtimeSessionToken.
        :type: str
        """
        self._token = token

    @property
    def session_id(self):
        """
        **[Required]** Gets the session_id of this RealtimeSessionToken.
        The session ID this token corresponds to. Provided for convenience, the session ID is already present in the JWT token.


        :return: The session_id of this RealtimeSessionToken.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this RealtimeSessionToken.
        The session ID this token corresponds to. Provided for convenience, the session ID is already present in the JWT token.


        :param session_id: The session_id of this RealtimeSessionToken.
        :type: str
        """
        self._session_id = session_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this RealtimeSessionToken.
        Compartment ID that was used to create the token.


        :return: The compartment_id of this RealtimeSessionToken.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RealtimeSessionToken.
        Compartment ID that was used to create the token.


        :param compartment_id: The compartment_id of this RealtimeSessionToken.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this RealtimeSessionToken.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`.


        :return: The freeform_tags of this RealtimeSessionToken.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this RealtimeSessionToken.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`.


        :param freeform_tags: The freeform_tags of this RealtimeSessionToken.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this RealtimeSessionToken.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace-1\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}, \"foo-namespace-2\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}}`.


        :return: The defined_tags of this RealtimeSessionToken.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this RealtimeSessionToken.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace-1\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}, \"foo-namespace-2\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}}`.


        :param defined_tags: The defined_tags of this RealtimeSessionToken.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
