# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResolvedEntity(object):
    """
    Resolved entity.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResolvedEntity object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ResolvedEntity.
        :type id: str

        :param offset:
            The value to assign to the offset property of this ResolvedEntity.
        :type offset: int

        :param length:
            The value to assign to the length property of this ResolvedEntity.
        :type length: int

        :param text:
            The value to assign to the text property of this ResolvedEntity.
        :type text: str

        :param type:
            The value to assign to the type property of this ResolvedEntity.
        :type type: str

        :param value:
            The value to assign to the value property of this ResolvedEntity.
        :type value: dict(str, str)

        """
        self.swagger_types = {
            'id': 'str',
            'offset': 'int',
            'length': 'int',
            'text': 'str',
            'type': 'str',
            'value': 'dict(str, str)'
        }
        self.attribute_map = {
            'id': 'id',
            'offset': 'offset',
            'length': 'length',
            'text': 'text',
            'type': 'type',
            'value': 'value'
        }
        self._id = None
        self._offset = None
        self._length = None
        self._text = None
        self._type = None
        self._value = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ResolvedEntity.
        id of the resolved entity in input


        :return: The id of this ResolvedEntity.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ResolvedEntity.
        id of the resolved entity in input


        :param id: The id of this ResolvedEntity.
        :type: str
        """
        self._id = id

    @property
    def offset(self):
        """
        **[Required]** Gets the offset of this ResolvedEntity.
        offset of resolved entity in input


        :return: The offset of this ResolvedEntity.
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """
        Sets the offset of this ResolvedEntity.
        offset of resolved entity in input


        :param offset: The offset of this ResolvedEntity.
        :type: int
        """
        self._offset = offset

    @property
    def length(self):
        """
        **[Required]** Gets the length of this ResolvedEntity.
        length of resolved entity in input


        :return: The length of this ResolvedEntity.
        :rtype: int
        """
        return self._length

    @length.setter
    def length(self, length):
        """
        Sets the length of this ResolvedEntity.
        length of resolved entity in input


        :param length: The length of this ResolvedEntity.
        :type: int
        """
        self._length = length

    @property
    def text(self):
        """
        **[Required]** Gets the text of this ResolvedEntity.
        Entity text like name of person, location, and so on.


        :return: The text of this ResolvedEntity.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this ResolvedEntity.
        Entity text like name of person, location, and so on.


        :param text: The text of this ResolvedEntity.
        :type: str
        """
        self._text = text

    @property
    def type(self):
        """
        **[Required]** Gets the type of this ResolvedEntity.
        Type of entity text like PER, LOC.


        :return: The type of this ResolvedEntity.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ResolvedEntity.
        Type of entity text like PER, LOC.


        :param type: The type of this ResolvedEntity.
        :type: str
        """
        self._type = type

    @property
    def value(self):
        """
        **[Required]** Gets the value of this ResolvedEntity.
        key and value pair for resolved entities. keys can be specific for each type of resolved entity. Values can be instances of resolvedEntity, arrays of resolvedEntities, primitives, or custom JSON.


        :return: The value of this ResolvedEntity.
        :rtype: dict(str, str)
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this ResolvedEntity.
        key and value pair for resolved entities. keys can be specific for each type of resolved entity. Values can be instances of resolvedEntity, arrays of resolvedEntities, primitives, or custom JSON.


        :param value: The value of this ResolvedEntity.
        :type: dict(str, str)
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
