# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerableArtifactVersionRange(object):
    """
    Vulnerable artifact version range.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerableArtifactVersionRange object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param version_end_excluding:
            The value to assign to the version_end_excluding property of this VulnerableArtifactVersionRange.
        :type version_end_excluding: str

        :param version_end_including:
            The value to assign to the version_end_including property of this VulnerableArtifactVersionRange.
        :type version_end_including: str

        :param version_start_including:
            The value to assign to the version_start_including property of this VulnerableArtifactVersionRange.
        :type version_start_including: str

        :param version_start_excluding:
            The value to assign to the version_start_excluding property of this VulnerableArtifactVersionRange.
        :type version_start_excluding: str

        """
        self.swagger_types = {
            'version_end_excluding': 'str',
            'version_end_including': 'str',
            'version_start_including': 'str',
            'version_start_excluding': 'str'
        }
        self.attribute_map = {
            'version_end_excluding': 'versionEndExcluding',
            'version_end_including': 'versionEndIncluding',
            'version_start_including': 'versionStartIncluding',
            'version_start_excluding': 'versionStartExcluding'
        }
        self._version_end_excluding = None
        self._version_end_including = None
        self._version_start_including = None
        self._version_start_excluding = None

    @property
    def version_end_excluding(self):
        """
        Gets the version_end_excluding of this VulnerableArtifactVersionRange.
        The version immediately after the last affected version. Versions up to, but not including this version, are vulnerable.


        :return: The version_end_excluding of this VulnerableArtifactVersionRange.
        :rtype: str
        """
        return self._version_end_excluding

    @version_end_excluding.setter
    def version_end_excluding(self, version_end_excluding):
        """
        Sets the version_end_excluding of this VulnerableArtifactVersionRange.
        The version immediately after the last affected version. Versions up to, but not including this version, are vulnerable.


        :param version_end_excluding: The version_end_excluding of this VulnerableArtifactVersionRange.
        :type: str
        """
        self._version_end_excluding = version_end_excluding

    @property
    def version_end_including(self):
        """
        Gets the version_end_including of this VulnerableArtifactVersionRange.
        Marks the latest version that is affected by the vulnerability. This version and all preceding versions, going back to versionStartExcluding or versionStartIncluding, are considered vulnerable.


        :return: The version_end_including of this VulnerableArtifactVersionRange.
        :rtype: str
        """
        return self._version_end_including

    @version_end_including.setter
    def version_end_including(self, version_end_including):
        """
        Sets the version_end_including of this VulnerableArtifactVersionRange.
        Marks the latest version that is affected by the vulnerability. This version and all preceding versions, going back to versionStartExcluding or versionStartIncluding, are considered vulnerable.


        :param version_end_including: The version_end_including of this VulnerableArtifactVersionRange.
        :type: str
        """
        self._version_end_including = version_end_including

    @property
    def version_start_including(self):
        """
        Gets the version_start_including of this VulnerableArtifactVersionRange.
        The first version affected by the vulnerability. This version and those following it are considered vulnerable until versionEndExcluding or versionEndIncluding is reached.


        :return: The version_start_including of this VulnerableArtifactVersionRange.
        :rtype: str
        """
        return self._version_start_including

    @version_start_including.setter
    def version_start_including(self, version_start_including):
        """
        Sets the version_start_including of this VulnerableArtifactVersionRange.
        The first version affected by the vulnerability. This version and those following it are considered vulnerable until versionEndExcluding or versionEndIncluding is reached.


        :param version_start_including: The version_start_including of this VulnerableArtifactVersionRange.
        :type: str
        """
        self._version_start_including = version_start_including

    @property
    def version_start_excluding(self):
        """
        Gets the version_start_excluding of this VulnerableArtifactVersionRange.
        The version immediately before the start of affected versions. The specified version is not affected, but versions immediately after are, up to versionStartIncluding or beyond, if not otherwise defined.


        :return: The version_start_excluding of this VulnerableArtifactVersionRange.
        :rtype: str
        """
        return self._version_start_excluding

    @version_start_excluding.setter
    def version_start_excluding(self, version_start_excluding):
        """
        Sets the version_start_excluding of this VulnerableArtifactVersionRange.
        The version immediately before the start of affected versions. The specified version is not affected, but versions immediately after are, up to versionStartIncluding or beyond, if not otherwise defined.


        :param version_start_excluding: The version_start_excluding of this VulnerableArtifactVersionRange.
        :type: str
        """
        self._version_start_excluding = version_start_excluding

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
