# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateFlexTunnelConfigurationDetails(object):
    """
    The update details for tunnel configuration.
    """

    #: A constant which can be used with the tunnel_type property of a UpdateFlexTunnelConfigurationDetails.
    #: This constant has a value of "GRE"
    TUNNEL_TYPE_GRE = "GRE"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateFlexTunnelConfigurationDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.vn_monitoring.models.UpdateGreFlexTunnelConfigurationDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tunnel_type:
            The value to assign to the tunnel_type property of this UpdateFlexTunnelConfigurationDetails.
            Allowed values for this property are: "GRE"
        :type tunnel_type: str

        :param customer_tunnel_ip:
            The value to assign to the customer_tunnel_ip property of this UpdateFlexTunnelConfigurationDetails.
        :type customer_tunnel_ip: str

        :param oracle_tunnel_ip:
            The value to assign to the oracle_tunnel_ip property of this UpdateFlexTunnelConfigurationDetails.
        :type oracle_tunnel_ip: str

        :param bgp_session:
            The value to assign to the bgp_session property of this UpdateFlexTunnelConfigurationDetails.
        :type bgp_session: oci.vn_monitoring.models.UpdateFlexTunnelBgpSessionDetails

        """
        self.swagger_types = {
            'tunnel_type': 'str',
            'customer_tunnel_ip': 'str',
            'oracle_tunnel_ip': 'str',
            'bgp_session': 'UpdateFlexTunnelBgpSessionDetails'
        }
        self.attribute_map = {
            'tunnel_type': 'tunnelType',
            'customer_tunnel_ip': 'customerTunnelIp',
            'oracle_tunnel_ip': 'oracleTunnelIp',
            'bgp_session': 'bgpSession'
        }
        self._tunnel_type = None
        self._customer_tunnel_ip = None
        self._oracle_tunnel_ip = None
        self._bgp_session = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['tunnelType']

        if type == 'GRE':
            return 'UpdateGreFlexTunnelConfigurationDetails'
        else:
            return 'UpdateFlexTunnelConfigurationDetails'

    @property
    def tunnel_type(self):
        """
        **[Required]** Gets the tunnel_type of this UpdateFlexTunnelConfigurationDetails.
        The tunnel encapsulation protocol.

        Allowed values for this property are: "GRE"


        :return: The tunnel_type of this UpdateFlexTunnelConfigurationDetails.
        :rtype: str
        """
        return self._tunnel_type

    @tunnel_type.setter
    def tunnel_type(self, tunnel_type):
        """
        Sets the tunnel_type of this UpdateFlexTunnelConfigurationDetails.
        The tunnel encapsulation protocol.


        :param tunnel_type: The tunnel_type of this UpdateFlexTunnelConfigurationDetails.
        :type: str
        """
        allowed_values = ["GRE"]
        if not value_allowed_none_or_none_sentinel(tunnel_type, allowed_values):
            raise ValueError(
                f"Invalid value for `tunnel_type`, must be None or one of {allowed_values}"
            )
        self._tunnel_type = tunnel_type

    @property
    def customer_tunnel_ip(self):
        """
        Gets the customer_tunnel_ip of this UpdateFlexTunnelConfigurationDetails.
        IP address of your end of the tunnel.


        :return: The customer_tunnel_ip of this UpdateFlexTunnelConfigurationDetails.
        :rtype: str
        """
        return self._customer_tunnel_ip

    @customer_tunnel_ip.setter
    def customer_tunnel_ip(self, customer_tunnel_ip):
        """
        Sets the customer_tunnel_ip of this UpdateFlexTunnelConfigurationDetails.
        IP address of your end of the tunnel.


        :param customer_tunnel_ip: The customer_tunnel_ip of this UpdateFlexTunnelConfigurationDetails.
        :type: str
        """
        self._customer_tunnel_ip = customer_tunnel_ip

    @property
    def oracle_tunnel_ip(self):
        """
        Gets the oracle_tunnel_ip of this UpdateFlexTunnelConfigurationDetails.
        IP address of the oracle end of the tunnel.


        :return: The oracle_tunnel_ip of this UpdateFlexTunnelConfigurationDetails.
        :rtype: str
        """
        return self._oracle_tunnel_ip

    @oracle_tunnel_ip.setter
    def oracle_tunnel_ip(self, oracle_tunnel_ip):
        """
        Sets the oracle_tunnel_ip of this UpdateFlexTunnelConfigurationDetails.
        IP address of the oracle end of the tunnel.


        :param oracle_tunnel_ip: The oracle_tunnel_ip of this UpdateFlexTunnelConfigurationDetails.
        :type: str
        """
        self._oracle_tunnel_ip = oracle_tunnel_ip

    @property
    def bgp_session(self):
        """
        Gets the bgp_session of this UpdateFlexTunnelConfigurationDetails.

        :return: The bgp_session of this UpdateFlexTunnelConfigurationDetails.
        :rtype: oci.vn_monitoring.models.UpdateFlexTunnelBgpSessionDetails
        """
        return self._bgp_session

    @bgp_session.setter
    def bgp_session(self, bgp_session):
        """
        Sets the bgp_session of this UpdateFlexTunnelConfigurationDetails.

        :param bgp_session: The bgp_session of this UpdateFlexTunnelConfigurationDetails.
        :type: oci.vn_monitoring.models.UpdateFlexTunnelBgpSessionDetails
        """
        self._bgp_session = bgp_session

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
