# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrgCustomer(object):
    """
    The list of IPSEC / FC / RPC info for a given DRG
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DrgCustomer object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param drg_id:
            The value to assign to the drg_id property of this DrgCustomer.
        :type drg_id: str

        :param remote_peering_connections:
            The value to assign to the remote_peering_connections property of this DrgCustomer.
        :type remote_peering_connections: list[oci.vn_monitoring.models.DrgCustomerResource]

        :param virtual_circuits:
            The value to assign to the virtual_circuits property of this DrgCustomer.
        :type virtual_circuits: list[oci.vn_monitoring.models.DrgCustomerResource]

        :param ipsec_connections:
            The value to assign to the ipsec_connections property of this DrgCustomer.
        :type ipsec_connections: list[oci.vn_monitoring.models.DrgCustomerResource]

        """
        self.swagger_types = {
            'drg_id': 'str',
            'remote_peering_connections': 'list[DrgCustomerResource]',
            'virtual_circuits': 'list[DrgCustomerResource]',
            'ipsec_connections': 'list[DrgCustomerResource]'
        }
        self.attribute_map = {
            'drg_id': 'drgId',
            'remote_peering_connections': 'remotePeeringConnections',
            'virtual_circuits': 'virtualCircuits',
            'ipsec_connections': 'ipsecConnections'
        }
        self._drg_id = None
        self._remote_peering_connections = None
        self._virtual_circuits = None
        self._ipsec_connections = None

    @property
    def drg_id(self):
        """
        **[Required]** Gets the drg_id of this DrgCustomer.
        OCID of the DRG


        :return: The drg_id of this DrgCustomer.
        :rtype: str
        """
        return self._drg_id

    @drg_id.setter
    def drg_id(self, drg_id):
        """
        Sets the drg_id of this DrgCustomer.
        OCID of the DRG


        :param drg_id: The drg_id of this DrgCustomer.
        :type: str
        """
        self._drg_id = drg_id

    @property
    def remote_peering_connections(self):
        """
        Gets the remote_peering_connections of this DrgCustomer.
        A List of the RPC connections on this DRG


        :return: The remote_peering_connections of this DrgCustomer.
        :rtype: list[oci.vn_monitoring.models.DrgCustomerResource]
        """
        return self._remote_peering_connections

    @remote_peering_connections.setter
    def remote_peering_connections(self, remote_peering_connections):
        """
        Sets the remote_peering_connections of this DrgCustomer.
        A List of the RPC connections on this DRG


        :param remote_peering_connections: The remote_peering_connections of this DrgCustomer.
        :type: list[oci.vn_monitoring.models.DrgCustomerResource]
        """
        self._remote_peering_connections = remote_peering_connections

    @property
    def virtual_circuits(self):
        """
        Gets the virtual_circuits of this DrgCustomer.
        A List of the VCs on this DRG


        :return: The virtual_circuits of this DrgCustomer.
        :rtype: list[oci.vn_monitoring.models.DrgCustomerResource]
        """
        return self._virtual_circuits

    @virtual_circuits.setter
    def virtual_circuits(self, virtual_circuits):
        """
        Sets the virtual_circuits of this DrgCustomer.
        A List of the VCs on this DRG


        :param virtual_circuits: The virtual_circuits of this DrgCustomer.
        :type: list[oci.vn_monitoring.models.DrgCustomerResource]
        """
        self._virtual_circuits = virtual_circuits

    @property
    def ipsec_connections(self):
        """
        Gets the ipsec_connections of this DrgCustomer.
        A List of the IPSec connections on this DRG


        :return: The ipsec_connections of this DrgCustomer.
        :rtype: list[oci.vn_monitoring.models.DrgCustomerResource]
        """
        return self._ipsec_connections

    @ipsec_connections.setter
    def ipsec_connections(self, ipsec_connections):
        """
        Sets the ipsec_connections of this DrgCustomer.
        A List of the IPSec connections on this DRG


        :param ipsec_connections: The ipsec_connections of this DrgCustomer.
        :type: list[oci.vn_monitoring.models.DrgCustomerResource]
        """
        self._ipsec_connections = ipsec_connections

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
