# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrgAttachmentNetworkCreateDetails(object):
    """
    DrgAttachmentNetworkCreateDetails model.
    """

    #: A constant which can be used with the type property of a DrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "VCN"
    TYPE_VCN = "VCN"

    #: A constant which can be used with the type property of a DrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "VIRTUAL_CIRCUIT"
    TYPE_VIRTUAL_CIRCUIT = "VIRTUAL_CIRCUIT"

    #: A constant which can be used with the type property of a DrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "REMOTE_PEERING_CONNECTION"
    TYPE_REMOTE_PEERING_CONNECTION = "REMOTE_PEERING_CONNECTION"

    #: A constant which can be used with the type property of a DrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "IPSEC_TUNNEL"
    TYPE_IPSEC_TUNNEL = "IPSEC_TUNNEL"

    #: A constant which can be used with the type property of a DrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "LOOPBACK"
    TYPE_LOOPBACK = "LOOPBACK"

    #: A constant which can be used with the type property of a DrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "FLEX_TUNNEL"
    TYPE_FLEX_TUNNEL = "FLEX_TUNNEL"

    #: A constant which can be used with the type property of a DrgAttachmentNetworkCreateDetails.
    #: This constant has a value of "INTERNET"
    TYPE_INTERNET = "INTERNET"

    def __init__(self, **kwargs):
        """
        Initializes a new DrgAttachmentNetworkCreateDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.vn_monitoring.models.IpsecTunnelDrgAttachmentNetworkCreateDetails`
        * :class:`~oci.vn_monitoring.models.LoopBackDrgAttachmentNetworkCreateDetails`
        * :class:`~oci.vn_monitoring.models.VirtualCircuitDrgAttachmentNetworkCreateDetails`
        * :class:`~oci.vn_monitoring.models.RemotePeeringConnectionDrgAttachmentNetworkCreateDetails`
        * :class:`~oci.vn_monitoring.models.InternetDrgAttachmentNetworkCreateDetails`
        * :class:`~oci.vn_monitoring.models.VcnDrgAttachmentNetworkCreateDetails`
        * :class:`~oci.vn_monitoring.models.FlexTunnelDrgAttachmentNetworkCreateDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this DrgAttachmentNetworkCreateDetails.
            Allowed values for this property are: "VCN", "VIRTUAL_CIRCUIT", "REMOTE_PEERING_CONNECTION", "IPSEC_TUNNEL", "LOOPBACK", "FLEX_TUNNEL", "INTERNET"
        :type type: str

        :param id:
            The value to assign to the id property of this DrgAttachmentNetworkCreateDetails.
        :type id: str

        """
        self.swagger_types = {
            'type': 'str',
            'id': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'id': 'id'
        }
        self._type = None
        self._id = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'IPSEC_TUNNEL':
            return 'IpsecTunnelDrgAttachmentNetworkCreateDetails'

        if type == 'LOOPBACK':
            return 'LoopBackDrgAttachmentNetworkCreateDetails'

        if type == 'VIRTUAL_CIRCUIT':
            return 'VirtualCircuitDrgAttachmentNetworkCreateDetails'

        if type == 'REMOTE_PEERING_CONNECTION':
            return 'RemotePeeringConnectionDrgAttachmentNetworkCreateDetails'

        if type == 'INTERNET':
            return 'InternetDrgAttachmentNetworkCreateDetails'

        if type == 'VCN':
            return 'VcnDrgAttachmentNetworkCreateDetails'

        if type == 'FLEX_TUNNEL':
            return 'FlexTunnelDrgAttachmentNetworkCreateDetails'
        else:
            return 'DrgAttachmentNetworkCreateDetails'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this DrgAttachmentNetworkCreateDetails.
        Allowed values for this property are: "VCN", "VIRTUAL_CIRCUIT", "REMOTE_PEERING_CONNECTION", "IPSEC_TUNNEL", "LOOPBACK", "FLEX_TUNNEL", "INTERNET"


        :return: The type of this DrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this DrgAttachmentNetworkCreateDetails.

        :param type: The type of this DrgAttachmentNetworkCreateDetails.
        :type: str
        """
        allowed_values = ["VCN", "VIRTUAL_CIRCUIT", "REMOTE_PEERING_CONNECTION", "IPSEC_TUNNEL", "LOOPBACK", "FLEX_TUNNEL", "INTERNET"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def id(self):
        """
        Gets the id of this DrgAttachmentNetworkCreateDetails.
        The `OCID`__ of the network attached to the DRG.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this DrgAttachmentNetworkCreateDetails.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DrgAttachmentNetworkCreateDetails.
        The `OCID`__ of the network attached to the DRG.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this DrgAttachmentNetworkCreateDetails.
        :type: str
        """
        self._id = id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
