# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateFlexTunnelDetails(object):
    """
    These details can be included in a request to create a flex tunnel.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateFlexTunnelDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateFlexTunnelDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateFlexTunnelDetails.
        :type display_name: str

        :param drg_id:
            The value to assign to the drg_id property of this CreateFlexTunnelDetails.
        :type drg_id: str

        :param transport_attachment_id:
            The value to assign to the transport_attachment_id property of this CreateFlexTunnelDetails.
        :type transport_attachment_id: str

        :param drg_route_table_id:
            The value to assign to the drg_route_table_id property of this CreateFlexTunnelDetails.
        :type drg_route_table_id: str

        :param flex_tunnel_configuration:
            The value to assign to the flex_tunnel_configuration property of this CreateFlexTunnelDetails.
        :type flex_tunnel_configuration: oci.vn_monitoring.models.CreateFlexTunnelConfigurationDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateFlexTunnelDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateFlexTunnelDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'drg_id': 'str',
            'transport_attachment_id': 'str',
            'drg_route_table_id': 'str',
            'flex_tunnel_configuration': 'CreateFlexTunnelConfigurationDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'drg_id': 'drgId',
            'transport_attachment_id': 'transportAttachmentId',
            'drg_route_table_id': 'drgRouteTableId',
            'flex_tunnel_configuration': 'flexTunnelConfiguration',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._drg_id = None
        self._transport_attachment_id = None
        self._drg_route_table_id = None
        self._flex_tunnel_configuration = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateFlexTunnelDetails.
        The `OCID`__ of the compartment to contain the flex tunnel.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateFlexTunnelDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateFlexTunnelDetails.
        The `OCID`__ of the compartment to contain the flex tunnel.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateFlexTunnelDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateFlexTunnelDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this CreateFlexTunnelDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateFlexTunnelDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreateFlexTunnelDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def drg_id(self):
        """
        **[Required]** Gets the drg_id of this CreateFlexTunnelDetails.
        The `OCID`__ of the DRG for loopback attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The drg_id of this CreateFlexTunnelDetails.
        :rtype: str
        """
        return self._drg_id

    @drg_id.setter
    def drg_id(self, drg_id):
        """
        Sets the drg_id of this CreateFlexTunnelDetails.
        The `OCID`__ of the DRG for loopback attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param drg_id: The drg_id of this CreateFlexTunnelDetails.
        :type: str
        """
        self._drg_id = drg_id

    @property
    def transport_attachment_id(self):
        """
        **[Required]** Gets the transport_attachment_id of this CreateFlexTunnelDetails.
        The `OCID`__ of the transport attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The transport_attachment_id of this CreateFlexTunnelDetails.
        :rtype: str
        """
        return self._transport_attachment_id

    @transport_attachment_id.setter
    def transport_attachment_id(self, transport_attachment_id):
        """
        Sets the transport_attachment_id of this CreateFlexTunnelDetails.
        The `OCID`__ of the transport attachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param transport_attachment_id: The transport_attachment_id of this CreateFlexTunnelDetails.
        :type: str
        """
        self._transport_attachment_id = transport_attachment_id

    @property
    def drg_route_table_id(self):
        """
        **[Required]** Gets the drg_route_table_id of this CreateFlexTunnelDetails.
        The `OCID`__ of the DRG route table.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The drg_route_table_id of this CreateFlexTunnelDetails.
        :rtype: str
        """
        return self._drg_route_table_id

    @drg_route_table_id.setter
    def drg_route_table_id(self, drg_route_table_id):
        """
        Sets the drg_route_table_id of this CreateFlexTunnelDetails.
        The `OCID`__ of the DRG route table.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param drg_route_table_id: The drg_route_table_id of this CreateFlexTunnelDetails.
        :type: str
        """
        self._drg_route_table_id = drg_route_table_id

    @property
    def flex_tunnel_configuration(self):
        """
        **[Required]** Gets the flex_tunnel_configuration of this CreateFlexTunnelDetails.

        :return: The flex_tunnel_configuration of this CreateFlexTunnelDetails.
        :rtype: oci.vn_monitoring.models.CreateFlexTunnelConfigurationDetails
        """
        return self._flex_tunnel_configuration

    @flex_tunnel_configuration.setter
    def flex_tunnel_configuration(self, flex_tunnel_configuration):
        """
        Sets the flex_tunnel_configuration of this CreateFlexTunnelDetails.

        :param flex_tunnel_configuration: The flex_tunnel_configuration of this CreateFlexTunnelDetails.
        :type: oci.vn_monitoring.models.CreateFlexTunnelConfigurationDetails
        """
        self._flex_tunnel_configuration = flex_tunnel_configuration

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateFlexTunnelDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateFlexTunnelDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateFlexTunnelDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateFlexTunnelDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateFlexTunnelDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateFlexTunnelDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateFlexTunnelDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateFlexTunnelDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
