# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330

from .monitored_resource_task_details import MonitoredResourceTaskDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateResourceTypeConfigTaskDetails(MonitoredResourceTaskDetails):
    """
    Update the availability metrics and the handler configuration for
    the telegraf/collectd resource types.
    """

    #: A constant which can be used with the handler_type property of a UpdateResourceTypeConfigTaskDetails.
    #: This constant has a value of "TELEGRAF"
    HANDLER_TYPE_TELEGRAF = "TELEGRAF"

    #: A constant which can be used with the handler_type property of a UpdateResourceTypeConfigTaskDetails.
    #: This constant has a value of "COLLECTD"
    HANDLER_TYPE_COLLECTD = "COLLECTD"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateResourceTypeConfigTaskDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.stack_monitoring.models.UpdateResourceTypeConfigTaskDetails.type` attribute
        of this class is ``UPDATE_RESOURCE_TYPE_CONFIGS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this UpdateResourceTypeConfigTaskDetails.
            Allowed values for this property are: "IMPORT_OCI_TELEMETRY_RESOURCES", "UPDATE_AGENT_RECEIVER", "UPDATE_RESOURCE_TYPE_CONFIGS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param handler_type:
            The value to assign to the handler_type property of this UpdateResourceTypeConfigTaskDetails.
            Allowed values for this property are: "TELEGRAF", "COLLECTD", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type handler_type: str

        :param resource_types_configuration:
            The value to assign to the resource_types_configuration property of this UpdateResourceTypeConfigTaskDetails.
        :type resource_types_configuration: list[oci.stack_monitoring.models.ResourceTypeConfigDetails]

        """
        self.swagger_types = {
            'type': 'str',
            'handler_type': 'str',
            'resource_types_configuration': 'list[ResourceTypeConfigDetails]'
        }
        self.attribute_map = {
            'type': 'type',
            'handler_type': 'handlerType',
            'resource_types_configuration': 'resourceTypesConfiguration'
        }
        self._type = None
        self._handler_type = None
        self._resource_types_configuration = None
        self._type = 'UPDATE_RESOURCE_TYPE_CONFIGS'

    @property
    def handler_type(self):
        """
        **[Required]** Gets the handler_type of this UpdateResourceTypeConfigTaskDetails.
        Type of the handler.

        Allowed values for this property are: "TELEGRAF", "COLLECTD", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The handler_type of this UpdateResourceTypeConfigTaskDetails.
        :rtype: str
        """
        return self._handler_type

    @handler_type.setter
    def handler_type(self, handler_type):
        """
        Sets the handler_type of this UpdateResourceTypeConfigTaskDetails.
        Type of the handler.


        :param handler_type: The handler_type of this UpdateResourceTypeConfigTaskDetails.
        :type: str
        """
        allowed_values = ["TELEGRAF", "COLLECTD"]
        if not value_allowed_none_or_none_sentinel(handler_type, allowed_values):
            handler_type = 'UNKNOWN_ENUM_VALUE'
        self._handler_type = handler_type

    @property
    def resource_types_configuration(self):
        """
        **[Required]** Gets the resource_types_configuration of this UpdateResourceTypeConfigTaskDetails.
        A collection of resource type configuration details. User can provide
        availability proxy metrics list for resource types along with the
        telegraf/collectd handler configuration for the resource types.


        :return: The resource_types_configuration of this UpdateResourceTypeConfigTaskDetails.
        :rtype: list[oci.stack_monitoring.models.ResourceTypeConfigDetails]
        """
        return self._resource_types_configuration

    @resource_types_configuration.setter
    def resource_types_configuration(self, resource_types_configuration):
        """
        Sets the resource_types_configuration of this UpdateResourceTypeConfigTaskDetails.
        A collection of resource type configuration details. User can provide
        availability proxy metrics list for resource types along with the
        telegraf/collectd handler configuration for the resource types.


        :param resource_types_configuration: The resource_types_configuration of this UpdateResourceTypeConfigTaskDetails.
        :type: list[oci.stack_monitoring.models.ResourceTypeConfigDetails]
        """
        self._resource_types_configuration = resource_types_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
