# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330

from .config_summary import ConfigSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LicenseAutoAssignConfigSummary(ConfigSummary):
    """
    Summary of a LICENSE_AUTO_ASSIGN configuration.
    """

    #: A constant which can be used with the license property of a LicenseAutoAssignConfigSummary.
    #: This constant has a value of "STANDARD_EDITION"
    LICENSE_STANDARD_EDITION = "STANDARD_EDITION"

    #: A constant which can be used with the license property of a LicenseAutoAssignConfigSummary.
    #: This constant has a value of "ENTERPRISE_EDITION"
    LICENSE_ENTERPRISE_EDITION = "ENTERPRISE_EDITION"

    #: A constant which can be used with the license property of a LicenseAutoAssignConfigSummary.
    #: This constant has a value of "ENTERPRISE_EDITION_FOR_GPU_INFRASTRUCTURE"
    LICENSE_ENTERPRISE_EDITION_FOR_GPU_INFRASTRUCTURE = "ENTERPRISE_EDITION_FOR_GPU_INFRASTRUCTURE"

    def __init__(self, **kwargs):
        """
        Initializes a new LicenseAutoAssignConfigSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.stack_monitoring.models.LicenseAutoAssignConfigSummary.config_type` attribute
        of this class is ``LICENSE_AUTO_ASSIGN`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this LicenseAutoAssignConfigSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this LicenseAutoAssignConfigSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this LicenseAutoAssignConfigSummary.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this LicenseAutoAssignConfigSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this LicenseAutoAssignConfigSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this LicenseAutoAssignConfigSummary.
        :type lifecycle_state: str

        :param config_type:
            The value to assign to the config_type property of this LicenseAutoAssignConfigSummary.
        :type config_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this LicenseAutoAssignConfigSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this LicenseAutoAssignConfigSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this LicenseAutoAssignConfigSummary.
        :type system_tags: dict(str, dict(str, object))

        :param license:
            The value to assign to the license property of this LicenseAutoAssignConfigSummary.
            Allowed values for this property are: "STANDARD_EDITION", "ENTERPRISE_EDITION", "ENTERPRISE_EDITION_FOR_GPU_INFRASTRUCTURE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type license: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'config_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'license': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'config_type': 'configType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'license': 'license'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._config_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._license = None
        self._config_type = 'LICENSE_AUTO_ASSIGN'

    @property
    def license(self):
        """
        **[Required]** Gets the license of this LicenseAutoAssignConfigSummary.
        License edition.

        Allowed values for this property are: "STANDARD_EDITION", "ENTERPRISE_EDITION", "ENTERPRISE_EDITION_FOR_GPU_INFRASTRUCTURE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The license of this LicenseAutoAssignConfigSummary.
        :rtype: str
        """
        return self._license

    @license.setter
    def license(self, license):
        """
        Sets the license of this LicenseAutoAssignConfigSummary.
        License edition.


        :param license: The license of this LicenseAutoAssignConfigSummary.
        :type: str
        """
        allowed_values = ["STANDARD_EDITION", "ENTERPRISE_EDITION", "ENTERPRISE_EDITION_FOR_GPU_INFRASTRUCTURE"]
        if not value_allowed_none_or_none_sentinel(license, allowed_values):
            license = 'UNKNOWN_ENUM_VALUE'
        self._license = license

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
