# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AgentExtensionHandlerMetricMappingDetails(object):
    """
    Specific metric mapping configurations for Agent Extension Handlers.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AgentExtensionHandlerMetricMappingDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param collector_metric_name:
            The value to assign to the collector_metric_name property of this AgentExtensionHandlerMetricMappingDetails.
        :type collector_metric_name: str

        :param telemetry_metric_name:
            The value to assign to the telemetry_metric_name property of this AgentExtensionHandlerMetricMappingDetails.
        :type telemetry_metric_name: str

        :param is_skip_upload:
            The value to assign to the is_skip_upload property of this AgentExtensionHandlerMetricMappingDetails.
        :type is_skip_upload: bool

        :param metric_upload_interval_in_seconds:
            The value to assign to the metric_upload_interval_in_seconds property of this AgentExtensionHandlerMetricMappingDetails.
        :type metric_upload_interval_in_seconds: int

        """
        self.swagger_types = {
            'collector_metric_name': 'str',
            'telemetry_metric_name': 'str',
            'is_skip_upload': 'bool',
            'metric_upload_interval_in_seconds': 'int'
        }
        self.attribute_map = {
            'collector_metric_name': 'collectorMetricName',
            'telemetry_metric_name': 'telemetryMetricName',
            'is_skip_upload': 'isSkipUpload',
            'metric_upload_interval_in_seconds': 'metricUploadIntervalInSeconds'
        }
        self._collector_metric_name = None
        self._telemetry_metric_name = None
        self._is_skip_upload = None
        self._metric_upload_interval_in_seconds = None

    @property
    def collector_metric_name(self):
        """
        **[Required]** Gets the collector_metric_name of this AgentExtensionHandlerMetricMappingDetails.
        Metric name as defined by the collector.


        :return: The collector_metric_name of this AgentExtensionHandlerMetricMappingDetails.
        :rtype: str
        """
        return self._collector_metric_name

    @collector_metric_name.setter
    def collector_metric_name(self, collector_metric_name):
        """
        Sets the collector_metric_name of this AgentExtensionHandlerMetricMappingDetails.
        Metric name as defined by the collector.


        :param collector_metric_name: The collector_metric_name of this AgentExtensionHandlerMetricMappingDetails.
        :type: str
        """
        self._collector_metric_name = collector_metric_name

    @property
    def telemetry_metric_name(self):
        """
        Gets the telemetry_metric_name of this AgentExtensionHandlerMetricMappingDetails.
        Metric name to be upload to telemetry.


        :return: The telemetry_metric_name of this AgentExtensionHandlerMetricMappingDetails.
        :rtype: str
        """
        return self._telemetry_metric_name

    @telemetry_metric_name.setter
    def telemetry_metric_name(self, telemetry_metric_name):
        """
        Sets the telemetry_metric_name of this AgentExtensionHandlerMetricMappingDetails.
        Metric name to be upload to telemetry.


        :param telemetry_metric_name: The telemetry_metric_name of this AgentExtensionHandlerMetricMappingDetails.
        :type: str
        """
        self._telemetry_metric_name = telemetry_metric_name

    @property
    def is_skip_upload(self):
        """
        Gets the is_skip_upload of this AgentExtensionHandlerMetricMappingDetails.
        Is ignoring this metric.


        :return: The is_skip_upload of this AgentExtensionHandlerMetricMappingDetails.
        :rtype: bool
        """
        return self._is_skip_upload

    @is_skip_upload.setter
    def is_skip_upload(self, is_skip_upload):
        """
        Sets the is_skip_upload of this AgentExtensionHandlerMetricMappingDetails.
        Is ignoring this metric.


        :param is_skip_upload: The is_skip_upload of this AgentExtensionHandlerMetricMappingDetails.
        :type: bool
        """
        self._is_skip_upload = is_skip_upload

    @property
    def metric_upload_interval_in_seconds(self):
        """
        Gets the metric_upload_interval_in_seconds of this AgentExtensionHandlerMetricMappingDetails.
        Metric upload interval in seconds. Any metric sent by telegraf/collectd before the
        configured interval expires will be dropped.


        :return: The metric_upload_interval_in_seconds of this AgentExtensionHandlerMetricMappingDetails.
        :rtype: int
        """
        return self._metric_upload_interval_in_seconds

    @metric_upload_interval_in_seconds.setter
    def metric_upload_interval_in_seconds(self, metric_upload_interval_in_seconds):
        """
        Sets the metric_upload_interval_in_seconds of this AgentExtensionHandlerMetricMappingDetails.
        Metric upload interval in seconds. Any metric sent by telegraf/collectd before the
        configured interval expires will be dropped.


        :param metric_upload_interval_in_seconds: The metric_upload_interval_in_seconds of this AgentExtensionHandlerMetricMappingDetails.
        :type: int
        """
        self._metric_upload_interval_in_seconds = metric_upload_interval_in_seconds

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
