# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200909


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TaskDetailsResponse(object):
    """
    An object that represents a task within the flow defined by the connector.
    An example task is a filter for error logs.
    For more information about flows defined by connectors, see
    `Overview of Connector Hub`__.
    For configuration instructions, see
    `Creating a Connector`__.

    __ https://docs.cloud.oracle.com/iaas/Content/connector-hub/overview.htm
    __ https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector.htm
    """

    #: A constant which can be used with the kind property of a TaskDetailsResponse.
    #: This constant has a value of "function"
    KIND_FUNCTION = "function"

    #: A constant which can be used with the kind property of a TaskDetailsResponse.
    #: This constant has a value of "logRule"
    KIND_LOG_RULE = "logRule"

    def __init__(self, **kwargs):
        """
        Initializes a new TaskDetailsResponse object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.sch.models.LogRuleTaskDetailsResponse`
        * :class:`~oci.sch.models.FunctionTaskDetailsResponse`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param private_endpoint_metadata:
            The value to assign to the private_endpoint_metadata property of this TaskDetailsResponse.
        :type private_endpoint_metadata: oci.sch.models.PrivateEndpointMetadata

        :param kind:
            The value to assign to the kind property of this TaskDetailsResponse.
            Allowed values for this property are: "function", "logRule", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type kind: str

        """
        self.swagger_types = {
            'private_endpoint_metadata': 'PrivateEndpointMetadata',
            'kind': 'str'
        }
        self.attribute_map = {
            'private_endpoint_metadata': 'privateEndpointMetadata',
            'kind': 'kind'
        }
        self._private_endpoint_metadata = None
        self._kind = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['kind']

        if type == 'logRule':
            return 'LogRuleTaskDetailsResponse'

        if type == 'function':
            return 'FunctionTaskDetailsResponse'
        else:
            return 'TaskDetailsResponse'

    @property
    def private_endpoint_metadata(self):
        """
        Gets the private_endpoint_metadata of this TaskDetailsResponse.

        :return: The private_endpoint_metadata of this TaskDetailsResponse.
        :rtype: oci.sch.models.PrivateEndpointMetadata
        """
        return self._private_endpoint_metadata

    @private_endpoint_metadata.setter
    def private_endpoint_metadata(self, private_endpoint_metadata):
        """
        Sets the private_endpoint_metadata of this TaskDetailsResponse.

        :param private_endpoint_metadata: The private_endpoint_metadata of this TaskDetailsResponse.
        :type: oci.sch.models.PrivateEndpointMetadata
        """
        self._private_endpoint_metadata = private_endpoint_metadata

    @property
    def kind(self):
        """
        **[Required]** Gets the kind of this TaskDetailsResponse.
        The type discriminator.

        Allowed values for this property are: "function", "logRule", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The kind of this TaskDetailsResponse.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """
        Sets the kind of this TaskDetailsResponse.
        The type discriminator.


        :param kind: The kind of this TaskDetailsResponse.
        :type: str
        """
        allowed_values = ["function", "logRule"]
        if not value_allowed_none_or_none_sentinel(kind, allowed_values):
            kind = 'UNKNOWN_ENUM_VALUE'
        self._kind = kind

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
