# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240430

from .parameter import Parameter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PathParameter(Parameter):
    """
    This is an input parameter that will be passed as URL path parameter.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PathParameter object with values from keyword arguments. The default value of the :py:attr:`~oci.resource_scheduler.models.PathParameter.parameter_type` attribute
        of this class is ``PATH`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param parameter_type:
            The value to assign to the parameter_type property of this PathParameter.
            Allowed values for this property are: "HEADER", "BODY", "PATH", "QUERY"
        :type parameter_type: str

        :param value:
            The value to assign to the value property of this PathParameter.
        :type value: dict(str, str)

        """
        self.swagger_types = {
            'parameter_type': 'str',
            'value': 'dict(str, str)'
        }
        self.attribute_map = {
            'parameter_type': 'parameterType',
            'value': 'value'
        }
        self._parameter_type = None
        self._value = None
        self._parameter_type = 'PATH'

    @property
    def value(self):
        """
        Gets the value of this PathParameter.
        This is the path parameter value.


        :return: The value of this PathParameter.
        :rtype: dict(str, str)
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this PathParameter.
        This is the path parameter value.


        :param value: The value of this PathParameter.
        :type: dict(str, str)
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
