# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StorageDetails(object):
    """
    Storage details of the database system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new StorageDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.psql.models.OciOptimizedStorageDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param system_type:
            The value to assign to the system_type property of this StorageDetails.
        :type system_type: str

        :param is_regionally_durable:
            The value to assign to the is_regionally_durable property of this StorageDetails.
        :type is_regionally_durable: bool

        :param availability_domain:
            The value to assign to the availability_domain property of this StorageDetails.
        :type availability_domain: str

        """
        self.swagger_types = {
            'system_type': 'str',
            'is_regionally_durable': 'bool',
            'availability_domain': 'str'
        }
        self.attribute_map = {
            'system_type': 'systemType',
            'is_regionally_durable': 'isRegionallyDurable',
            'availability_domain': 'availabilityDomain'
        }
        self._system_type = None
        self._is_regionally_durable = None
        self._availability_domain = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['systemType']

        if type == 'OCI_OPTIMIZED_STORAGE':
            return 'OciOptimizedStorageDetails'
        else:
            return 'StorageDetails'

    @property
    def system_type(self):
        """
        **[Required]** Gets the system_type of this StorageDetails.
        Type of the database system.


        :return: The system_type of this StorageDetails.
        :rtype: str
        """
        return self._system_type

    @system_type.setter
    def system_type(self, system_type):
        """
        Sets the system_type of this StorageDetails.
        Type of the database system.


        :param system_type: The system_type of this StorageDetails.
        :type: str
        """
        self._system_type = system_type

    @property
    def is_regionally_durable(self):
        """
        **[Required]** Gets the is_regionally_durable of this StorageDetails.
        Specifies if the block volume used for the database system is regional or AD-local.
        If not specified, it will be set to false.
        If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified.
        If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.


        :return: The is_regionally_durable of this StorageDetails.
        :rtype: bool
        """
        return self._is_regionally_durable

    @is_regionally_durable.setter
    def is_regionally_durable(self, is_regionally_durable):
        """
        Sets the is_regionally_durable of this StorageDetails.
        Specifies if the block volume used for the database system is regional or AD-local.
        If not specified, it will be set to false.
        If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified.
        If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.


        :param is_regionally_durable: The is_regionally_durable of this StorageDetails.
        :type: bool
        """
        self._is_regionally_durable = is_regionally_durable

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this StorageDetails.
        Specifies the availability domain of AD-local storage.
        If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified.
        If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.


        :return: The availability_domain of this StorageDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this StorageDetails.
        Specifies the availability domain of AD-local storage.
        If `isRegionallyDurable` is set to true, `availabilityDomain` should not be specified.
        If `isRegionallyDurable` is set to false, `availabilityDomain` must be specified.


        :param availability_domain: The availability_domain of this StorageDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
