# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AddPackagesToSoftwareSourceDetails(object):
    """
    Provides the list of packages to add to a software source.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AddPackagesToSoftwareSourceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param packages:
            The value to assign to the packages property of this AddPackagesToSoftwareSourceDetails.
        :type packages: list[str]

        :param is_continue_on_missing_packages:
            The value to assign to the is_continue_on_missing_packages property of this AddPackagesToSoftwareSourceDetails.
        :type is_continue_on_missing_packages: bool

        """
        self.swagger_types = {
            'packages': 'list[str]',
            'is_continue_on_missing_packages': 'bool'
        }
        self.attribute_map = {
            'packages': 'packages',
            'is_continue_on_missing_packages': 'isContinueOnMissingPackages'
        }
        self._packages = None
        self._is_continue_on_missing_packages = None

    @property
    def packages(self):
        """
        **[Required]** Gets the packages of this AddPackagesToSoftwareSourceDetails.
        List of packages specified by the name of the package (N) or the full package name (NVRA or NEVRA).


        :return: The packages of this AddPackagesToSoftwareSourceDetails.
        :rtype: list[str]
        """
        return self._packages

    @packages.setter
    def packages(self, packages):
        """
        Sets the packages of this AddPackagesToSoftwareSourceDetails.
        List of packages specified by the name of the package (N) or the full package name (NVRA or NEVRA).


        :param packages: The packages of this AddPackagesToSoftwareSourceDetails.
        :type: list[str]
        """
        self._packages = packages

    @property
    def is_continue_on_missing_packages(self):
        """
        Gets the is_continue_on_missing_packages of this AddPackagesToSoftwareSourceDetails.
        Indicates whether the service should generate a custom software source when the package list contains invalid values. When set to true, the service ignores any invalid packages and generates the custom software source with using the valid packages.


        :return: The is_continue_on_missing_packages of this AddPackagesToSoftwareSourceDetails.
        :rtype: bool
        """
        return self._is_continue_on_missing_packages

    @is_continue_on_missing_packages.setter
    def is_continue_on_missing_packages(self, is_continue_on_missing_packages):
        """
        Sets the is_continue_on_missing_packages of this AddPackagesToSoftwareSourceDetails.
        Indicates whether the service should generate a custom software source when the package list contains invalid values. When set to true, the service ignores any invalid packages and generates the custom software source with using the valid packages.


        :param is_continue_on_missing_packages: The is_continue_on_missing_packages of this AddPackagesToSoftwareSourceDetails.
        :type: bool
        """
        self._is_continue_on_missing_packages = is_continue_on_missing_packages

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
