# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .database_configuration_metric_group import DatabaseConfigurationMetricGroup
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadataAsmEntity(DatabaseConfigurationMetricGroup):
    """
    ASM entitie for an exadata
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExadataAsmEntity object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.ExadataAsmEntity.metric_name` attribute
        of this class is ``ASM_ENTITY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this ExadataAsmEntity.
            Allowed values for this property are: "DB_EXTERNAL_PROPERTIES", "DB_EXTERNAL_INSTANCE", "DB_OS_CONFIG_INSTANCE", "DB_PARAMETERS", "DB_CONNECTION_STATUS", "HOST_RESOURCE_ALLOCATION", "ASM_ENTITY", "EXADATA_CELL_CONFIG"
        :type metric_name: str

        :param time_collected:
            The value to assign to the time_collected property of this ExadataAsmEntity.
        :type time_collected: datetime

        :param instance_name:
            The value to assign to the instance_name property of this ExadataAsmEntity.
        :type instance_name: str

        :param cluster_name:
            The value to assign to the cluster_name property of this ExadataAsmEntity.
        :type cluster_name: str

        :param software_version:
            The value to assign to the software_version property of this ExadataAsmEntity.
        :type software_version: str

        """
        self.swagger_types = {
            'metric_name': 'str',
            'time_collected': 'datetime',
            'instance_name': 'str',
            'cluster_name': 'str',
            'software_version': 'str'
        }
        self.attribute_map = {
            'metric_name': 'metricName',
            'time_collected': 'timeCollected',
            'instance_name': 'instanceName',
            'cluster_name': 'clusterName',
            'software_version': 'softwareVersion'
        }
        self._metric_name = None
        self._time_collected = None
        self._instance_name = None
        self._cluster_name = None
        self._software_version = None
        self._metric_name = 'ASM_ENTITY'

    @property
    def instance_name(self):
        """
        Gets the instance_name of this ExadataAsmEntity.
        Instance name of ASM


        :return: The instance_name of this ExadataAsmEntity.
        :rtype: str
        """
        return self._instance_name

    @instance_name.setter
    def instance_name(self, instance_name):
        """
        Sets the instance_name of this ExadataAsmEntity.
        Instance name of ASM


        :param instance_name: The instance_name of this ExadataAsmEntity.
        :type: str
        """
        self._instance_name = instance_name

    @property
    def cluster_name(self):
        """
        Gets the cluster_name of this ExadataAsmEntity.
        Cluster name of ASM


        :return: The cluster_name of this ExadataAsmEntity.
        :rtype: str
        """
        return self._cluster_name

    @cluster_name.setter
    def cluster_name(self, cluster_name):
        """
        Sets the cluster_name of this ExadataAsmEntity.
        Cluster name of ASM


        :param cluster_name: The cluster_name of this ExadataAsmEntity.
        :type: str
        """
        self._cluster_name = cluster_name

    @property
    def software_version(self):
        """
        Gets the software_version of this ExadataAsmEntity.
        Software version


        :return: The software_version of this ExadataAsmEntity.
        :rtype: str
        """
        return self._software_version

    @software_version.setter
    def software_version(self, software_version):
        """
        Sets the software_version of this ExadataAsmEntity.
        Software version


        :param software_version: The software_version of this ExadataAsmEntity.
        :type: str
        """
        self._software_version = software_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
