# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AwrHubSources(object):
    """
    Logical grouping used for Awr Hub Source operations.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AwrHubSources object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param awr_hub_sources:
            The value to assign to the awr_hub_sources property of this AwrHubSources.
        :type awr_hub_sources: object

        """
        self.swagger_types = {
            'awr_hub_sources': 'object'
        }
        self.attribute_map = {
            'awr_hub_sources': 'awrHubSources'
        }
        self._awr_hub_sources = None

    @property
    def awr_hub_sources(self):
        """
        Gets the awr_hub_sources of this AwrHubSources.
        Awr Hub Source Object.


        :return: The awr_hub_sources of this AwrHubSources.
        :rtype: object
        """
        return self._awr_hub_sources

    @awr_hub_sources.setter
    def awr_hub_sources(self, awr_hub_sources):
        """
        Sets the awr_hub_sources of this AwrHubSources.
        Awr Hub Source Object.


        :param awr_hub_sources: The awr_hub_sources of this AwrHubSources.
        :type: object
        """
        self._awr_hub_sources = awr_hub_sources

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
