# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaintenanceNotificationDetails(object):
    """
    Notification details for the maintenance activity.
    """

    #: A constant which can be used with the maintenance_notification_type property of a MaintenanceNotificationDetails.
    #: This constant has a value of "SCHEDULED_MAINTENANCE_WITH_RELEASE_NOTES"
    MAINTENANCE_NOTIFICATION_TYPE_SCHEDULED_MAINTENANCE_WITH_RELEASE_NOTES = "SCHEDULED_MAINTENANCE_WITH_RELEASE_NOTES"

    #: A constant which can be used with the maintenance_notification_type property of a MaintenanceNotificationDetails.
    #: This constant has a value of "SCHEDULED_MAINTENANCE_WITHOUT_RELEASE_NOTES"
    MAINTENANCE_NOTIFICATION_TYPE_SCHEDULED_MAINTENANCE_WITHOUT_RELEASE_NOTES = "SCHEDULED_MAINTENANCE_WITHOUT_RELEASE_NOTES"

    #: A constant which can be used with the maintenance_notification_type property of a MaintenanceNotificationDetails.
    #: This constant has a value of "RESCHEDULED_MAINTENANCE"
    MAINTENANCE_NOTIFICATION_TYPE_RESCHEDULED_MAINTENANCE = "RESCHEDULED_MAINTENANCE"

    #: A constant which can be used with the maintenance_notification_type property of a MaintenanceNotificationDetails.
    #: This constant has a value of "SCHEDULED_MAINTENANCE_REMINDER"
    MAINTENANCE_NOTIFICATION_TYPE_SCHEDULED_MAINTENANCE_REMINDER = "SCHEDULED_MAINTENANCE_REMINDER"

    #: A constant which can be used with the maintenance_notification_type property of a MaintenanceNotificationDetails.
    #: This constant has a value of "SCHEDULED_MAINTENANCE_COMPLETED"
    MAINTENANCE_NOTIFICATION_TYPE_SCHEDULED_MAINTENANCE_COMPLETED = "SCHEDULED_MAINTENANCE_COMPLETED"

    def __init__(self, **kwargs):
        """
        Initializes a new MaintenanceNotificationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param jira_ticket:
            The value to assign to the jira_ticket property of this MaintenanceNotificationDetails.
        :type jira_ticket: str

        :param maintenance_notification_type:
            The value to assign to the maintenance_notification_type property of this MaintenanceNotificationDetails.
            Allowed values for this property are: "SCHEDULED_MAINTENANCE_WITH_RELEASE_NOTES", "SCHEDULED_MAINTENANCE_WITHOUT_RELEASE_NOTES", "RESCHEDULED_MAINTENANCE", "SCHEDULED_MAINTENANCE_REMINDER", "SCHEDULED_MAINTENANCE_COMPLETED"
        :type maintenance_notification_type: str

        :param tenant_ids:
            The value to assign to the tenant_ids property of this MaintenanceNotificationDetails.
        :type tenant_ids: list[str]

        :param cluster_ids:
            The value to assign to the cluster_ids property of this MaintenanceNotificationDetails.
        :type cluster_ids: list[str]

        :param start_time:
            The value to assign to the start_time property of this MaintenanceNotificationDetails.
        :type start_time: str

        :param end_time:
            The value to assign to the end_time property of this MaintenanceNotificationDetails.
        :type end_time: str

        """
        self.swagger_types = {
            'jira_ticket': 'str',
            'maintenance_notification_type': 'str',
            'tenant_ids': 'list[str]',
            'cluster_ids': 'list[str]',
            'start_time': 'str',
            'end_time': 'str'
        }
        self.attribute_map = {
            'jira_ticket': 'jiraTicket',
            'maintenance_notification_type': 'maintenanceNotificationType',
            'tenant_ids': 'tenantIds',
            'cluster_ids': 'clusterIds',
            'start_time': 'startTime',
            'end_time': 'endTime'
        }
        self._jira_ticket = None
        self._maintenance_notification_type = None
        self._tenant_ids = None
        self._cluster_ids = None
        self._start_time = None
        self._end_time = None

    @property
    def jira_ticket(self):
        """
        **[Required]** Gets the jira_ticket of this MaintenanceNotificationDetails.
        Jira tickets for on-call engineer to send customer notification


        :return: The jira_ticket of this MaintenanceNotificationDetails.
        :rtype: str
        """
        return self._jira_ticket

    @jira_ticket.setter
    def jira_ticket(self, jira_ticket):
        """
        Sets the jira_ticket of this MaintenanceNotificationDetails.
        Jira tickets for on-call engineer to send customer notification


        :param jira_ticket: The jira_ticket of this MaintenanceNotificationDetails.
        :type: str
        """
        self._jira_ticket = jira_ticket

    @property
    def maintenance_notification_type(self):
        """
        **[Required]** Gets the maintenance_notification_type of this MaintenanceNotificationDetails.
        Maintenance Notification type

        Allowed values for this property are: "SCHEDULED_MAINTENANCE_WITH_RELEASE_NOTES", "SCHEDULED_MAINTENANCE_WITHOUT_RELEASE_NOTES", "RESCHEDULED_MAINTENANCE", "SCHEDULED_MAINTENANCE_REMINDER", "SCHEDULED_MAINTENANCE_COMPLETED"


        :return: The maintenance_notification_type of this MaintenanceNotificationDetails.
        :rtype: str
        """
        return self._maintenance_notification_type

    @maintenance_notification_type.setter
    def maintenance_notification_type(self, maintenance_notification_type):
        """
        Sets the maintenance_notification_type of this MaintenanceNotificationDetails.
        Maintenance Notification type


        :param maintenance_notification_type: The maintenance_notification_type of this MaintenanceNotificationDetails.
        :type: str
        """
        allowed_values = ["SCHEDULED_MAINTENANCE_WITH_RELEASE_NOTES", "SCHEDULED_MAINTENANCE_WITHOUT_RELEASE_NOTES", "RESCHEDULED_MAINTENANCE", "SCHEDULED_MAINTENANCE_REMINDER", "SCHEDULED_MAINTENANCE_COMPLETED"]
        if not value_allowed_none_or_none_sentinel(maintenance_notification_type, allowed_values):
            raise ValueError(
                f"Invalid value for `maintenance_notification_type`, must be None or one of {allowed_values}"
            )
        self._maintenance_notification_type = maintenance_notification_type

    @property
    def tenant_ids(self):
        """
        Gets the tenant_ids of this MaintenanceNotificationDetails.
        List of tenantIds where we need to send the maintenance notifications


        :return: The tenant_ids of this MaintenanceNotificationDetails.
        :rtype: list[str]
        """
        return self._tenant_ids

    @tenant_ids.setter
    def tenant_ids(self, tenant_ids):
        """
        Sets the tenant_ids of this MaintenanceNotificationDetails.
        List of tenantIds where we need to send the maintenance notifications


        :param tenant_ids: The tenant_ids of this MaintenanceNotificationDetails.
        :type: list[str]
        """
        self._tenant_ids = tenant_ids

    @property
    def cluster_ids(self):
        """
        Gets the cluster_ids of this MaintenanceNotificationDetails.
        List of OpenSearch clusterIds where we need to send the maintenance notifications


        :return: The cluster_ids of this MaintenanceNotificationDetails.
        :rtype: list[str]
        """
        return self._cluster_ids

    @cluster_ids.setter
    def cluster_ids(self, cluster_ids):
        """
        Sets the cluster_ids of this MaintenanceNotificationDetails.
        List of OpenSearch clusterIds where we need to send the maintenance notifications


        :param cluster_ids: The cluster_ids of this MaintenanceNotificationDetails.
        :type: list[str]
        """
        self._cluster_ids = cluster_ids

    @property
    def start_time(self):
        """
        Gets the start_time of this MaintenanceNotificationDetails.
        Start time for the notification activity in UTC like \"2023-20-04 04:00:00.000Z\"


        :return: The start_time of this MaintenanceNotificationDetails.
        :rtype: str
        """
        return self._start_time

    @start_time.setter
    def start_time(self, start_time):
        """
        Sets the start_time of this MaintenanceNotificationDetails.
        Start time for the notification activity in UTC like \"2023-20-04 04:00:00.000Z\"


        :param start_time: The start_time of this MaintenanceNotificationDetails.
        :type: str
        """
        self._start_time = start_time

    @property
    def end_time(self):
        """
        Gets the end_time of this MaintenanceNotificationDetails.
        Start time for the notification activity in UTC like \"2023-20-04 04:00:00.000Z\"


        :return: The end_time of this MaintenanceNotificationDetails.
        :rtype: str
        """
        return self._end_time

    @end_time.setter
    def end_time(self, end_time):
        """
        Sets the end_time of this MaintenanceNotificationDetails.
        Start time for the notification activity in UTC like \"2023-20-04 04:00:00.000Z\"


        :param end_time: The end_time of this MaintenanceNotificationDetails.
        :type: str
        """
        self._end_time = end_time

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
