# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MulticloudResourceSummary(object):
    """
    The multicloud resource, for eg. VMCluster, ExaInfra, and its attributes. The resource and network anchor that represents
    """

    #: A constant which can be used with the lifecycle_state property of a MulticloudResourceSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a MulticloudResourceSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new MulticloudResourceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_id:
            The value to assign to the resource_id property of this MulticloudResourceSummary.
        :type resource_id: str

        :param resource_display_name:
            The value to assign to the resource_display_name property of this MulticloudResourceSummary.
        :type resource_display_name: str

        :param resource_type:
            The value to assign to the resource_type property of this MulticloudResourceSummary.
        :type resource_type: str

        :param compartment_name:
            The value to assign to the compartment_name property of this MulticloudResourceSummary.
        :type compartment_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this MulticloudResourceSummary.
        :type compartment_id: str

        :param vcn_name:
            The value to assign to the vcn_name property of this MulticloudResourceSummary.
        :type vcn_name: str

        :param vcn_id:
            The value to assign to the vcn_id property of this MulticloudResourceSummary.
        :type vcn_id: str

        :param network_anchor_name:
            The value to assign to the network_anchor_name property of this MulticloudResourceSummary.
        :type network_anchor_name: str

        :param network_anchor_id:
            The value to assign to the network_anchor_id property of this MulticloudResourceSummary.
        :type network_anchor_id: str

        :param csp_resource_id:
            The value to assign to the csp_resource_id property of this MulticloudResourceSummary.
        :type csp_resource_id: str

        :param time_created:
            The value to assign to the time_created property of this MulticloudResourceSummary.
        :type time_created: datetime

        :param csp_additional_properties:
            The value to assign to the csp_additional_properties property of this MulticloudResourceSummary.
        :type csp_additional_properties: dict(str, str)

        :param time_updated:
            The value to assign to the time_updated property of this MulticloudResourceSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this MulticloudResourceSummary.
            Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this MulticloudResourceSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this MulticloudResourceSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this MulticloudResourceSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'resource_id': 'str',
            'resource_display_name': 'str',
            'resource_type': 'str',
            'compartment_name': 'str',
            'compartment_id': 'str',
            'vcn_name': 'str',
            'vcn_id': 'str',
            'network_anchor_name': 'str',
            'network_anchor_id': 'str',
            'csp_resource_id': 'str',
            'time_created': 'datetime',
            'csp_additional_properties': 'dict(str, str)',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'resource_id': 'resourceId',
            'resource_display_name': 'resourceDisplayName',
            'resource_type': 'resourceType',
            'compartment_name': 'compartmentName',
            'compartment_id': 'compartmentId',
            'vcn_name': 'vcnName',
            'vcn_id': 'vcnId',
            'network_anchor_name': 'networkAnchorName',
            'network_anchor_id': 'networkAnchorId',
            'csp_resource_id': 'cspResourceId',
            'time_created': 'timeCreated',
            'csp_additional_properties': 'cspAdditionalProperties',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._resource_id = None
        self._resource_display_name = None
        self._resource_type = None
        self._compartment_name = None
        self._compartment_id = None
        self._vcn_name = None
        self._vcn_id = None
        self._network_anchor_name = None
        self._network_anchor_id = None
        self._csp_resource_id = None
        self._time_created = None
        self._csp_additional_properties = None
        self._time_updated = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this MulticloudResourceSummary.
        The Id of the multicloud resource.


        :return: The resource_id of this MulticloudResourceSummary.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this MulticloudResourceSummary.
        The Id of the multicloud resource.


        :param resource_id: The resource_id of this MulticloudResourceSummary.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def resource_display_name(self):
        """
        Gets the resource_display_name of this MulticloudResourceSummary.
        Endpoint used to retrieve displayName and lifeCycleState of the resource.


        :return: The resource_display_name of this MulticloudResourceSummary.
        :rtype: str
        """
        return self._resource_display_name

    @resource_display_name.setter
    def resource_display_name(self, resource_display_name):
        """
        Sets the resource_display_name of this MulticloudResourceSummary.
        Endpoint used to retrieve displayName and lifeCycleState of the resource.


        :param resource_display_name: The resource_display_name of this MulticloudResourceSummary.
        :type: str
        """
        self._resource_display_name = resource_display_name

    @property
    def resource_type(self):
        """
        Gets the resource_type of this MulticloudResourceSummary.
        What resource it refers to. Eg. VMCluster, ExaInfra, etc.


        :return: The resource_type of this MulticloudResourceSummary.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this MulticloudResourceSummary.
        What resource it refers to. Eg. VMCluster, ExaInfra, etc.


        :param resource_type: The resource_type of this MulticloudResourceSummary.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def compartment_name(self):
        """
        Gets the compartment_name of this MulticloudResourceSummary.
        Compartment name associated the resource.


        :return: The compartment_name of this MulticloudResourceSummary.
        :rtype: str
        """
        return self._compartment_name

    @compartment_name.setter
    def compartment_name(self, compartment_name):
        """
        Sets the compartment_name of this MulticloudResourceSummary.
        Compartment name associated the resource.


        :param compartment_name: The compartment_name of this MulticloudResourceSummary.
        :type: str
        """
        self._compartment_name = compartment_name

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this MulticloudResourceSummary.
        Compartment Id of the resource.


        :return: The compartment_id of this MulticloudResourceSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this MulticloudResourceSummary.
        Compartment Id of the resource.


        :param compartment_id: The compartment_id of this MulticloudResourceSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def vcn_name(self):
        """
        Gets the vcn_name of this MulticloudResourceSummary.
        Resource Anchor name.


        :return: The vcn_name of this MulticloudResourceSummary.
        :rtype: str
        """
        return self._vcn_name

    @vcn_name.setter
    def vcn_name(self, vcn_name):
        """
        Sets the vcn_name of this MulticloudResourceSummary.
        Resource Anchor name.


        :param vcn_name: The vcn_name of this MulticloudResourceSummary.
        :type: str
        """
        self._vcn_name = vcn_name

    @property
    def vcn_id(self):
        """
        Gets the vcn_id of this MulticloudResourceSummary.
        Id of the Virtual Cloud Network associated to the resource.


        :return: The vcn_id of this MulticloudResourceSummary.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this MulticloudResourceSummary.
        Id of the Virtual Cloud Network associated to the resource.


        :param vcn_id: The vcn_id of this MulticloudResourceSummary.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def network_anchor_name(self):
        """
        Gets the network_anchor_name of this MulticloudResourceSummary.
        Name of the network anchor associated to the resource.


        :return: The network_anchor_name of this MulticloudResourceSummary.
        :rtype: str
        """
        return self._network_anchor_name

    @network_anchor_name.setter
    def network_anchor_name(self, network_anchor_name):
        """
        Sets the network_anchor_name of this MulticloudResourceSummary.
        Name of the network anchor associated to the resource.


        :param network_anchor_name: The network_anchor_name of this MulticloudResourceSummary.
        :type: str
        """
        self._network_anchor_name = network_anchor_name

    @property
    def network_anchor_id(self):
        """
        Gets the network_anchor_id of this MulticloudResourceSummary.
        OCID of the Network Anchor


        :return: The network_anchor_id of this MulticloudResourceSummary.
        :rtype: str
        """
        return self._network_anchor_id

    @network_anchor_id.setter
    def network_anchor_id(self, network_anchor_id):
        """
        Sets the network_anchor_id of this MulticloudResourceSummary.
        OCID of the Network Anchor


        :param network_anchor_id: The network_anchor_id of this MulticloudResourceSummary.
        :type: str
        """
        self._network_anchor_id = network_anchor_id

    @property
    def csp_resource_id(self):
        """
        Gets the csp_resource_id of this MulticloudResourceSummary.
        Resource Id that comes from the Multi Cloud Control Plane


        :return: The csp_resource_id of this MulticloudResourceSummary.
        :rtype: str
        """
        return self._csp_resource_id

    @csp_resource_id.setter
    def csp_resource_id(self, csp_resource_id):
        """
        Sets the csp_resource_id of this MulticloudResourceSummary.
        Resource Id that comes from the Multi Cloud Control Plane


        :param csp_resource_id: The csp_resource_id of this MulticloudResourceSummary.
        :type: str
        """
        self._csp_resource_id = csp_resource_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this MulticloudResourceSummary.
        The date and time the subscription was created, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this MulticloudResourceSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this MulticloudResourceSummary.
        The date and time the subscription was created, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this MulticloudResourceSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def csp_additional_properties(self):
        """
        Gets the csp_additional_properties of this MulticloudResourceSummary.
        CSP Specific Additional Properties, AzureSubnetId for Azure


        :return: The csp_additional_properties of this MulticloudResourceSummary.
        :rtype: dict(str, str)
        """
        return self._csp_additional_properties

    @csp_additional_properties.setter
    def csp_additional_properties(self, csp_additional_properties):
        """
        Sets the csp_additional_properties of this MulticloudResourceSummary.
        CSP Specific Additional Properties, AzureSubnetId for Azure


        :param csp_additional_properties: The csp_additional_properties of this MulticloudResourceSummary.
        :type: dict(str, str)
        """
        self._csp_additional_properties = csp_additional_properties

    @property
    def time_updated(self):
        """
        Gets the time_updated of this MulticloudResourceSummary.
        The date and time the subscription was updated, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this MulticloudResourceSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this MulticloudResourceSummary.
        The date and time the subscription was updated, in the format defined by
        `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this MulticloudResourceSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this MulticloudResourceSummary.
        The current state of the multicloud resource.

        Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this MulticloudResourceSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this MulticloudResourceSummary.
        The current state of the multicloud resource.


        :param lifecycle_state: The lifecycle_state of this MulticloudResourceSummary.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this MulticloudResourceSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this MulticloudResourceSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this MulticloudResourceSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this MulticloudResourceSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this MulticloudResourceSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this MulticloudResourceSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this MulticloudResourceSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this MulticloudResourceSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this MulticloudResourceSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this MulticloudResourceSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this MulticloudResourceSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this MulticloudResourceSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
