# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateMachineImageDetails(object):
    """
    Machine image details required to update a Image artifact.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateMachineImageDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_image_id:
            The value to assign to the source_image_id property of this UpdateMachineImageDetails.
        :type source_image_id: str

        :param username:
            The value to assign to the username property of this UpdateMachineImageDetails.
        :type username: str

        :param is_snapshot_allowed:
            The value to assign to the is_snapshot_allowed property of this UpdateMachineImageDetails.
        :type is_snapshot_allowed: bool

        :param image_shape_compatibility_entries:
            The value to assign to the image_shape_compatibility_entries property of this UpdateMachineImageDetails.
        :type image_shape_compatibility_entries: list[oci.marketplace_publisher.models.ImageShapeCompatibility]

        """
        self.swagger_types = {
            'source_image_id': 'str',
            'username': 'str',
            'is_snapshot_allowed': 'bool',
            'image_shape_compatibility_entries': 'list[ImageShapeCompatibility]'
        }
        self.attribute_map = {
            'source_image_id': 'sourceImageId',
            'username': 'username',
            'is_snapshot_allowed': 'isSnapshotAllowed',
            'image_shape_compatibility_entries': 'imageShapeCompatibilityEntries'
        }
        self._source_image_id = None
        self._username = None
        self._is_snapshot_allowed = None
        self._image_shape_compatibility_entries = None

    @property
    def source_image_id(self):
        """
        Gets the source_image_id of this UpdateMachineImageDetails.
        The OCID of source machine image.


        :return: The source_image_id of this UpdateMachineImageDetails.
        :rtype: str
        """
        return self._source_image_id

    @source_image_id.setter
    def source_image_id(self, source_image_id):
        """
        Sets the source_image_id of this UpdateMachineImageDetails.
        The OCID of source machine image.


        :param source_image_id: The source_image_id of this UpdateMachineImageDetails.
        :type: str
        """
        self._source_image_id = source_image_id

    @property
    def username(self):
        """
        Gets the username of this UpdateMachineImageDetails.
        The username for machine image.


        :return: The username of this UpdateMachineImageDetails.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this UpdateMachineImageDetails.
        The username for machine image.


        :param username: The username of this UpdateMachineImageDetails.
        :type: str
        """
        self._username = username

    @property
    def is_snapshot_allowed(self):
        """
        Gets the is_snapshot_allowed of this UpdateMachineImageDetails.
        Identified if customer can take a snapshot of instance running on the machine image.


        :return: The is_snapshot_allowed of this UpdateMachineImageDetails.
        :rtype: bool
        """
        return self._is_snapshot_allowed

    @is_snapshot_allowed.setter
    def is_snapshot_allowed(self, is_snapshot_allowed):
        """
        Sets the is_snapshot_allowed of this UpdateMachineImageDetails.
        Identified if customer can take a snapshot of instance running on the machine image.


        :param is_snapshot_allowed: The is_snapshot_allowed of this UpdateMachineImageDetails.
        :type: bool
        """
        self._is_snapshot_allowed = is_snapshot_allowed

    @property
    def image_shape_compatibility_entries(self):
        """
        Gets the image_shape_compatibility_entries of this UpdateMachineImageDetails.
        List of shape configurations supported by the image.


        :return: The image_shape_compatibility_entries of this UpdateMachineImageDetails.
        :rtype: list[oci.marketplace_publisher.models.ImageShapeCompatibility]
        """
        return self._image_shape_compatibility_entries

    @image_shape_compatibility_entries.setter
    def image_shape_compatibility_entries(self, image_shape_compatibility_entries):
        """
        Sets the image_shape_compatibility_entries of this UpdateMachineImageDetails.
        List of shape configurations supported by the image.


        :param image_shape_compatibility_entries: The image_shape_compatibility_entries of this UpdateMachineImageDetails.
        :type: list[oci.marketplace_publisher.models.ImageShapeCompatibility]
        """
        self._image_shape_compatibility_entries = image_shape_compatibility_entries

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
