# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateKafkaClusterDetails(object):
    """
    The data to create a KafkaCluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateKafkaClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateKafkaClusterDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateKafkaClusterDetails.
        :type compartment_id: str

        :param access_subnets:
            The value to assign to the access_subnets property of this CreateKafkaClusterDetails.
        :type access_subnets: list[oci.managed_kafka.models.SubnetSet]

        :param client_certificate_bundle:
            The value to assign to the client_certificate_bundle property of this CreateKafkaClusterDetails.
        :type client_certificate_bundle: str

        :param kafka_version:
            The value to assign to the kafka_version property of this CreateKafkaClusterDetails.
        :type kafka_version: str

        :param cluster_type:
            The value to assign to the cluster_type property of this CreateKafkaClusterDetails.
        :type cluster_type: str

        :param broker_shape:
            The value to assign to the broker_shape property of this CreateKafkaClusterDetails.
        :type broker_shape: oci.managed_kafka.models.BrokerShape

        :param cluster_config_id:
            The value to assign to the cluster_config_id property of this CreateKafkaClusterDetails.
        :type cluster_config_id: str

        :param cluster_config_version:
            The value to assign to the cluster_config_version property of this CreateKafkaClusterDetails.
        :type cluster_config_version: int

        :param coordination_type:
            The value to assign to the coordination_type property of this CreateKafkaClusterDetails.
        :type coordination_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateKafkaClusterDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateKafkaClusterDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'access_subnets': 'list[SubnetSet]',
            'client_certificate_bundle': 'str',
            'kafka_version': 'str',
            'cluster_type': 'str',
            'broker_shape': 'BrokerShape',
            'cluster_config_id': 'str',
            'cluster_config_version': 'int',
            'coordination_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'access_subnets': 'accessSubnets',
            'client_certificate_bundle': 'clientCertificateBundle',
            'kafka_version': 'kafkaVersion',
            'cluster_type': 'clusterType',
            'broker_shape': 'brokerShape',
            'cluster_config_id': 'clusterConfigId',
            'cluster_config_version': 'clusterConfigVersion',
            'coordination_type': 'coordinationType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._compartment_id = None
        self._access_subnets = None
        self._client_certificate_bundle = None
        self._kafka_version = None
        self._cluster_type = None
        self._broker_shape = None
        self._cluster_config_id = None
        self._cluster_config_version = None
        self._coordination_type = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateKafkaClusterDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateKafkaClusterDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateKafkaClusterDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateKafkaClusterDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateKafkaClusterDetails.
        The `OCID`__ of the compartment to create the KafkaCluster in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateKafkaClusterDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateKafkaClusterDetails.
        The `OCID`__ of the compartment to create the KafkaCluster in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateKafkaClusterDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def access_subnets(self):
        """
        **[Required]** Gets the access_subnets of this CreateKafkaClusterDetails.
        Subnets where broker/coordinator VNICs will be created.


        :return: The access_subnets of this CreateKafkaClusterDetails.
        :rtype: list[oci.managed_kafka.models.SubnetSet]
        """
        return self._access_subnets

    @access_subnets.setter
    def access_subnets(self, access_subnets):
        """
        Sets the access_subnets of this CreateKafkaClusterDetails.
        Subnets where broker/coordinator VNICs will be created.


        :param access_subnets: The access_subnets of this CreateKafkaClusterDetails.
        :type: list[oci.managed_kafka.models.SubnetSet]
        """
        self._access_subnets = access_subnets

    @property
    def client_certificate_bundle(self):
        """
        Gets the client_certificate_bundle of this CreateKafkaClusterDetails.
        CA certificate bundle for mTLS broker authentication.


        :return: The client_certificate_bundle of this CreateKafkaClusterDetails.
        :rtype: str
        """
        return self._client_certificate_bundle

    @client_certificate_bundle.setter
    def client_certificate_bundle(self, client_certificate_bundle):
        """
        Sets the client_certificate_bundle of this CreateKafkaClusterDetails.
        CA certificate bundle for mTLS broker authentication.


        :param client_certificate_bundle: The client_certificate_bundle of this CreateKafkaClusterDetails.
        :type: str
        """
        self._client_certificate_bundle = client_certificate_bundle

    @property
    def kafka_version(self):
        """
        **[Required]** Gets the kafka_version of this CreateKafkaClusterDetails.
        Version of Kafka to use to spin up the cluster


        :return: The kafka_version of this CreateKafkaClusterDetails.
        :rtype: str
        """
        return self._kafka_version

    @kafka_version.setter
    def kafka_version(self, kafka_version):
        """
        Sets the kafka_version of this CreateKafkaClusterDetails.
        Version of Kafka to use to spin up the cluster


        :param kafka_version: The kafka_version of this CreateKafkaClusterDetails.
        :type: str
        """
        self._kafka_version = kafka_version

    @property
    def cluster_type(self):
        """
        **[Required]** Gets the cluster_type of this CreateKafkaClusterDetails.
        Type of the cluster to spin up.
        DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on single node
        PRODUCTION - Minimum allowed broker count is 3


        :return: The cluster_type of this CreateKafkaClusterDetails.
        :rtype: str
        """
        return self._cluster_type

    @cluster_type.setter
    def cluster_type(self, cluster_type):
        """
        Sets the cluster_type of this CreateKafkaClusterDetails.
        Type of the cluster to spin up.
        DEVELOPMENT - setting that allows to sacrifice HA and spin up cluster on single node
        PRODUCTION - Minimum allowed broker count is 3


        :param cluster_type: The cluster_type of this CreateKafkaClusterDetails.
        :type: str
        """
        self._cluster_type = cluster_type

    @property
    def broker_shape(self):
        """
        **[Required]** Gets the broker_shape of this CreateKafkaClusterDetails.

        :return: The broker_shape of this CreateKafkaClusterDetails.
        :rtype: oci.managed_kafka.models.BrokerShape
        """
        return self._broker_shape

    @broker_shape.setter
    def broker_shape(self, broker_shape):
        """
        Sets the broker_shape of this CreateKafkaClusterDetails.

        :param broker_shape: The broker_shape of this CreateKafkaClusterDetails.
        :type: oci.managed_kafka.models.BrokerShape
        """
        self._broker_shape = broker_shape

    @property
    def cluster_config_id(self):
        """
        **[Required]** Gets the cluster_config_id of this CreateKafkaClusterDetails.
        The `OCID`__ of Kafka Cluster configuration object

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The cluster_config_id of this CreateKafkaClusterDetails.
        :rtype: str
        """
        return self._cluster_config_id

    @cluster_config_id.setter
    def cluster_config_id(self, cluster_config_id):
        """
        Sets the cluster_config_id of this CreateKafkaClusterDetails.
        The `OCID`__ of Kafka Cluster configuration object

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param cluster_config_id: The cluster_config_id of this CreateKafkaClusterDetails.
        :type: str
        """
        self._cluster_config_id = cluster_config_id

    @property
    def cluster_config_version(self):
        """
        **[Required]** Gets the cluster_config_version of this CreateKafkaClusterDetails.
        The version of configuration object


        :return: The cluster_config_version of this CreateKafkaClusterDetails.
        :rtype: int
        """
        return self._cluster_config_version

    @cluster_config_version.setter
    def cluster_config_version(self, cluster_config_version):
        """
        Sets the cluster_config_version of this CreateKafkaClusterDetails.
        The version of configuration object


        :param cluster_config_version: The cluster_config_version of this CreateKafkaClusterDetails.
        :type: int
        """
        self._cluster_config_version = cluster_config_version

    @property
    def coordination_type(self):
        """
        **[Required]** Gets the coordination_type of this CreateKafkaClusterDetails.
        Kafka coordination type. Set of available types depends on Kafka version


        :return: The coordination_type of this CreateKafkaClusterDetails.
        :rtype: str
        """
        return self._coordination_type

    @coordination_type.setter
    def coordination_type(self, coordination_type):
        """
        Sets the coordination_type of this CreateKafkaClusterDetails.
        Kafka coordination type. Set of available types depends on Kafka version


        :param coordination_type: The coordination_type of this CreateKafkaClusterDetails.
        :type: str
        """
        self._coordination_type = coordination_type

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateKafkaClusterDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateKafkaClusterDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateKafkaClusterDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateKafkaClusterDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateKafkaClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateKafkaClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateKafkaClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateKafkaClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
