# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: release


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HsmPartitionSummary(object):
    """
    An object which encapsulates the details of a given HSM.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HsmPartitionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this HsmPartitionSummary.
        :type id: str

        :param hsm_cluster_id:
            The value to assign to the hsm_cluster_id property of this HsmPartitionSummary.
        :type hsm_cluster_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this HsmPartitionSummary.
        :type lifecycle_state: str

        :param compartment_id:
            The value to assign to the compartment_id property of this HsmPartitionSummary.
        :type compartment_id: str

        :param port_information:
            The value to assign to the port_information property of this HsmPartitionSummary.
        :type port_information: list[oci.key_management.models.PortInformation]

        :param time_created:
            The value to assign to the time_created property of this HsmPartitionSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this HsmPartitionSummary.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'hsm_cluster_id': 'str',
            'lifecycle_state': 'str',
            'compartment_id': 'str',
            'port_information': 'list[PortInformation]',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'hsm_cluster_id': 'hsmClusterId',
            'lifecycle_state': 'lifecycleState',
            'compartment_id': 'compartmentId',
            'port_information': 'portInformation',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._id = None
        self._hsm_cluster_id = None
        self._lifecycle_state = None
        self._compartment_id = None
        self._port_information = None
        self._time_created = None
        self._time_updated = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this HsmPartitionSummary.
        The OCID of the HSM resource. Each HSM resource will have a unique OCID identifier.


        :return: The id of this HsmPartitionSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this HsmPartitionSummary.
        The OCID of the HSM resource. Each HSM resource will have a unique OCID identifier.


        :param id: The id of this HsmPartitionSummary.
        :type: str
        """
        self._id = id

    @property
    def hsm_cluster_id(self):
        """
        **[Required]** Gets the hsm_cluster_id of this HsmPartitionSummary.
        The OCID of the HSMCluster that contains a particular HSM resource.


        :return: The hsm_cluster_id of this HsmPartitionSummary.
        :rtype: str
        """
        return self._hsm_cluster_id

    @hsm_cluster_id.setter
    def hsm_cluster_id(self, hsm_cluster_id):
        """
        Sets the hsm_cluster_id of this HsmPartitionSummary.
        The OCID of the HSMCluster that contains a particular HSM resource.


        :param hsm_cluster_id: The hsm_cluster_id of this HsmPartitionSummary.
        :type: str
        """
        self._hsm_cluster_id = hsm_cluster_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this HsmPartitionSummary.
        A HSMCluster resource's current lifecycle state.

        Example: `ACTIVE`


        :return: The lifecycle_state of this HsmPartitionSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this HsmPartitionSummary.
        A HSMCluster resource's current lifecycle state.

        Example: `ACTIVE`


        :param lifecycle_state: The lifecycle_state of this HsmPartitionSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this HsmPartitionSummary.
        The OCID of the compartment that contains a particular HSM resource.


        :return: The compartment_id of this HsmPartitionSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this HsmPartitionSummary.
        The OCID of the compartment that contains a particular HSM resource.


        :param compartment_id: The compartment_id of this HsmPartitionSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def port_information(self):
        """
        **[Required]** Gets the port_information of this HsmPartitionSummary.
        Details of a single portInformation item include the PortNumber (an integer used as an identifier) and the PortType (refers to either an enum value of Managementutility,Clientutility, or null)


        :return: The port_information of this HsmPartitionSummary.
        :rtype: list[oci.key_management.models.PortInformation]
        """
        return self._port_information

    @port_information.setter
    def port_information(self, port_information):
        """
        Sets the port_information of this HsmPartitionSummary.
        Details of a single portInformation item include the PortNumber (an integer used as an identifier) and the PortType (refers to either an enum value of Managementutility,Clientutility, or null)


        :param port_information: The port_information of this HsmPartitionSummary.
        :type: list[oci.key_management.models.PortInformation]
        """
        self._port_information = port_information

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this HsmPartitionSummary.
        The date and time an HSM was created, expressed in `RFC 3339`__ timestamp format.

        Example: `2018-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this HsmPartitionSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this HsmPartitionSummary.
        The date and time an HSM was created, expressed in `RFC 3339`__ timestamp format.

        Example: `2018-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this HsmPartitionSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this HsmPartitionSummary.
        The date and time an HSM was updated, expressed in `RFC 3339`__ timestamp format.

        Example: `2018-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this HsmPartitionSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this HsmPartitionSummary.
        The date and time an HSM was updated, expressed in `RFC 3339`__ timestamp format.

        Example: `2018-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this HsmPartitionSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
