# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ContainerSummary(object):
    """
    Information about a container in the cluster.
    """

    #: A constant which can be used with the jre_security_status property of a ContainerSummary.
    #: This constant has a value of "EARLY_ACCESS"
    JRE_SECURITY_STATUS_EARLY_ACCESS = "EARLY_ACCESS"

    #: A constant which can be used with the jre_security_status property of a ContainerSummary.
    #: This constant has a value of "UNKNOWN"
    JRE_SECURITY_STATUS_UNKNOWN = "UNKNOWN"

    #: A constant which can be used with the jre_security_status property of a ContainerSummary.
    #: This constant has a value of "UP_TO_DATE"
    JRE_SECURITY_STATUS_UP_TO_DATE = "UP_TO_DATE"

    #: A constant which can be used with the jre_security_status property of a ContainerSummary.
    #: This constant has a value of "UPDATE_REQUIRED"
    JRE_SECURITY_STATUS_UPDATE_REQUIRED = "UPDATE_REQUIRED"

    #: A constant which can be used with the jre_security_status property of a ContainerSummary.
    #: This constant has a value of "UPGRADE_REQUIRED"
    JRE_SECURITY_STATUS_UPGRADE_REQUIRED = "UPGRADE_REQUIRED"

    def __init__(self, **kwargs):
        """
        Initializes a new ContainerSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param container_key:
            The value to assign to the container_key property of this ContainerSummary.
        :type container_key: str

        :param managed_instance_id:
            The value to assign to the managed_instance_id property of this ContainerSummary.
        :type managed_instance_id: str

        :param display_name:
            The value to assign to the display_name property of this ContainerSummary.
        :type display_name: str

        :param image_name:
            The value to assign to the image_name property of this ContainerSummary.
        :type image_name: str

        :param namespace:
            The value to assign to the namespace property of this ContainerSummary.
        :type namespace: str

        :param node_name:
            The value to assign to the node_name property of this ContainerSummary.
        :type node_name: str

        :param pod_name:
            The value to assign to the pod_name property of this ContainerSummary.
        :type pod_name: str

        :param application_key:
            The value to assign to the application_key property of this ContainerSummary.
        :type application_key: str

        :param application_name:
            The value to assign to the application_name property of this ContainerSummary.
        :type application_name: str

        :param jre_key:
            The value to assign to the jre_key property of this ContainerSummary.
        :type jre_key: str

        :param java_version:
            The value to assign to the java_version property of this ContainerSummary.
        :type java_version: str

        :param jre_security_status:
            The value to assign to the jre_security_status property of this ContainerSummary.
            Allowed values for this property are: "EARLY_ACCESS", "UNKNOWN", "UP_TO_DATE", "UPDATE_REQUIRED", "UPGRADE_REQUIRED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type jre_security_status: str

        :param time_started:
            The value to assign to the time_started property of this ContainerSummary.
        :type time_started: datetime

        """
        self.swagger_types = {
            'container_key': 'str',
            'managed_instance_id': 'str',
            'display_name': 'str',
            'image_name': 'str',
            'namespace': 'str',
            'node_name': 'str',
            'pod_name': 'str',
            'application_key': 'str',
            'application_name': 'str',
            'jre_key': 'str',
            'java_version': 'str',
            'jre_security_status': 'str',
            'time_started': 'datetime'
        }
        self.attribute_map = {
            'container_key': 'containerKey',
            'managed_instance_id': 'managedInstanceId',
            'display_name': 'displayName',
            'image_name': 'imageName',
            'namespace': 'namespace',
            'node_name': 'nodeName',
            'pod_name': 'podName',
            'application_key': 'applicationKey',
            'application_name': 'applicationName',
            'jre_key': 'jreKey',
            'java_version': 'javaVersion',
            'jre_security_status': 'jreSecurityStatus',
            'time_started': 'timeStarted'
        }
        self._container_key = None
        self._managed_instance_id = None
        self._display_name = None
        self._image_name = None
        self._namespace = None
        self._node_name = None
        self._pod_name = None
        self._application_key = None
        self._application_name = None
        self._jre_key = None
        self._java_version = None
        self._jre_security_status = None
        self._time_started = None

    @property
    def container_key(self):
        """
        **[Required]** Gets the container_key of this ContainerSummary.
        Unique identifier for the container.


        :return: The container_key of this ContainerSummary.
        :rtype: str
        """
        return self._container_key

    @container_key.setter
    def container_key(self, container_key):
        """
        Sets the container_key of this ContainerSummary.
        Unique identifier for the container.


        :param container_key: The container_key of this ContainerSummary.
        :type: str
        """
        self._container_key = container_key

    @property
    def managed_instance_id(self):
        """
        **[Required]** Gets the managed_instance_id of this ContainerSummary.
        The `OCID`__ of the associated managed instance of type OCMA.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The managed_instance_id of this ContainerSummary.
        :rtype: str
        """
        return self._managed_instance_id

    @managed_instance_id.setter
    def managed_instance_id(self, managed_instance_id):
        """
        Sets the managed_instance_id of this ContainerSummary.
        The `OCID`__ of the associated managed instance of type OCMA.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param managed_instance_id: The managed_instance_id of this ContainerSummary.
        :type: str
        """
        self._managed_instance_id = managed_instance_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ContainerSummary.
        The name of the container.


        :return: The display_name of this ContainerSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ContainerSummary.
        The name of the container.


        :param display_name: The display_name of this ContainerSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def image_name(self):
        """
        **[Required]** Gets the image_name of this ContainerSummary.
        The container image name.


        :return: The image_name of this ContainerSummary.
        :rtype: str
        """
        return self._image_name

    @image_name.setter
    def image_name(self, image_name):
        """
        Sets the image_name of this ContainerSummary.
        The container image name.


        :param image_name: The image_name of this ContainerSummary.
        :type: str
        """
        self._image_name = image_name

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this ContainerSummary.
        The namespace of the container.


        :return: The namespace of this ContainerSummary.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this ContainerSummary.
        The namespace of the container.


        :param namespace: The namespace of this ContainerSummary.
        :type: str
        """
        self._namespace = namespace

    @property
    def node_name(self):
        """
        **[Required]** Gets the node_name of this ContainerSummary.
        The name of the node associated with the pod running this container.


        :return: The node_name of this ContainerSummary.
        :rtype: str
        """
        return self._node_name

    @node_name.setter
    def node_name(self, node_name):
        """
        Sets the node_name of this ContainerSummary.
        The name of the node associated with the pod running this container.


        :param node_name: The node_name of this ContainerSummary.
        :type: str
        """
        self._node_name = node_name

    @property
    def pod_name(self):
        """
        **[Required]** Gets the pod_name of this ContainerSummary.
        The name of the pod running this container.


        :return: The pod_name of this ContainerSummary.
        :rtype: str
        """
        return self._pod_name

    @pod_name.setter
    def pod_name(self, pod_name):
        """
        Sets the pod_name of this ContainerSummary.
        The name of the pod running this container.


        :param pod_name: The pod_name of this ContainerSummary.
        :type: str
        """
        self._pod_name = pod_name

    @property
    def application_key(self):
        """
        Gets the application_key of this ContainerSummary.
        Unique key that identifies the application running in the container.


        :return: The application_key of this ContainerSummary.
        :rtype: str
        """
        return self._application_key

    @application_key.setter
    def application_key(self, application_key):
        """
        Sets the application_key of this ContainerSummary.
        Unique key that identifies the application running in the container.


        :param application_key: The application_key of this ContainerSummary.
        :type: str
        """
        self._application_key = application_key

    @property
    def application_name(self):
        """
        Gets the application_name of this ContainerSummary.
        The name of the application running in the container.


        :return: The application_name of this ContainerSummary.
        :rtype: str
        """
        return self._application_name

    @application_name.setter
    def application_name(self, application_name):
        """
        Sets the application_name of this ContainerSummary.
        The name of the application running in the container.


        :param application_name: The application_name of this ContainerSummary.
        :type: str
        """
        self._application_name = application_name

    @property
    def jre_key(self):
        """
        Gets the jre_key of this ContainerSummary.
        Unique key that identifies the Java runtime used to run the application in the container.


        :return: The jre_key of this ContainerSummary.
        :rtype: str
        """
        return self._jre_key

    @jre_key.setter
    def jre_key(self, jre_key):
        """
        Sets the jre_key of this ContainerSummary.
        Unique key that identifies the Java runtime used to run the application in the container.


        :param jre_key: The jre_key of this ContainerSummary.
        :type: str
        """
        self._jre_key = jre_key

    @property
    def java_version(self):
        """
        Gets the java_version of this ContainerSummary.
        The Java runtime used to run the application in the container.


        :return: The java_version of this ContainerSummary.
        :rtype: str
        """
        return self._java_version

    @java_version.setter
    def java_version(self, java_version):
        """
        Sets the java_version of this ContainerSummary.
        The Java runtime used to run the application in the container.


        :param java_version: The java_version of this ContainerSummary.
        :type: str
        """
        self._java_version = java_version

    @property
    def jre_security_status(self):
        """
        Gets the jre_security_status of this ContainerSummary.
        The security status of the Java runtime used to run the application in the container.

        Allowed values for this property are: "EARLY_ACCESS", "UNKNOWN", "UP_TO_DATE", "UPDATE_REQUIRED", "UPGRADE_REQUIRED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The jre_security_status of this ContainerSummary.
        :rtype: str
        """
        return self._jre_security_status

    @jre_security_status.setter
    def jre_security_status(self, jre_security_status):
        """
        Sets the jre_security_status of this ContainerSummary.
        The security status of the Java runtime used to run the application in the container.


        :param jre_security_status: The jre_security_status of this ContainerSummary.
        :type: str
        """
        allowed_values = ["EARLY_ACCESS", "UNKNOWN", "UP_TO_DATE", "UPDATE_REQUIRED", "UPGRADE_REQUIRED"]
        if not value_allowed_none_or_none_sentinel(jre_security_status, allowed_values):
            jre_security_status = 'UNKNOWN_ENUM_VALUE'
        self._jre_security_status = jre_security_status

    @property
    def time_started(self):
        """
        Gets the time_started of this ContainerSummary.
        The start time of the container.


        :return: The time_started of this ContainerSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this ContainerSummary.
        The start time of the container.


        :param time_started: The time_started of this ContainerSummary.
        :type: datetime
        """
        self._time_started = time_started

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
