# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UrlCitation(object):
    """
    Contains metadata for a cited URL included in the assistant\u2019s response.
    Includes the cited URL and title, and the character range (start and end indices)
    in the response `content` where the citation applies.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UrlCitation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param start_index:
            The value to assign to the start_index property of this UrlCitation.
        :type start_index: int

        :param end_index:
            The value to assign to the end_index property of this UrlCitation.
        :type end_index: int

        :param title:
            The value to assign to the title property of this UrlCitation.
        :type title: str

        :param url:
            The value to assign to the url property of this UrlCitation.
        :type url: str

        """
        self.swagger_types = {
            'start_index': 'int',
            'end_index': 'int',
            'title': 'str',
            'url': 'str'
        }
        self.attribute_map = {
            'start_index': 'startIndex',
            'end_index': 'endIndex',
            'title': 'title',
            'url': 'url'
        }
        self._start_index = None
        self._end_index = None
        self._title = None
        self._url = None

    @property
    def start_index(self):
        """
        Gets the start_index of this UrlCitation.
        Start character index in the response where the citation begins.


        :return: The start_index of this UrlCitation.
        :rtype: int
        """
        return self._start_index

    @start_index.setter
    def start_index(self, start_index):
        """
        Sets the start_index of this UrlCitation.
        Start character index in the response where the citation begins.


        :param start_index: The start_index of this UrlCitation.
        :type: int
        """
        self._start_index = start_index

    @property
    def end_index(self):
        """
        Gets the end_index of this UrlCitation.
        End character index in the response where the citation ends.


        :return: The end_index of this UrlCitation.
        :rtype: int
        """
        return self._end_index

    @end_index.setter
    def end_index(self, end_index):
        """
        Sets the end_index of this UrlCitation.
        End character index in the response where the citation ends.


        :param end_index: The end_index of this UrlCitation.
        :type: int
        """
        self._end_index = end_index

    @property
    def title(self):
        """
        Gets the title of this UrlCitation.
        Title of the cited source.


        :return: The title of this UrlCitation.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this UrlCitation.
        Title of the cited source.


        :param title: The title of this UrlCitation.
        :type: str
        """
        self._title = title

    @property
    def url(self):
        """
        Gets the url of this UrlCitation.
        URL of the cited source.


        :return: The url of this UrlCitation.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this UrlCitation.
        URL of the cited source.


        :param url: The url of this UrlCitation.
        :type: str
        """
        self._url = url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
