# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StreamOptions(object):
    """
    Options for streaming response. Only set this when you set stream: true.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new StreamOptions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_include_usage:
            The value to assign to the is_include_usage property of this StreamOptions.
        :type is_include_usage: bool

        """
        self.swagger_types = {
            'is_include_usage': 'bool'
        }
        self.attribute_map = {
            'is_include_usage': 'isIncludeUsage'
        }
        self._is_include_usage = None

    @property
    def is_include_usage(self):
        """
        Gets the is_include_usage of this StreamOptions.
        If set, an additional chunk will be streamed before the data: [DONE] message. The usage field on this chunk shows the token usage statistics for the entire request


        :return: The is_include_usage of this StreamOptions.
        :rtype: bool
        """
        return self._is_include_usage

    @is_include_usage.setter
    def is_include_usage(self, is_include_usage):
        """
        Sets the is_include_usage of this StreamOptions.
        If set, an additional chunk will be streamed before the data: [DONE] message. The usage field on this chunk shows the token usage statistics for the entire request


        :param is_include_usage: The is_include_usage of this StreamOptions.
        :type: bool
        """
        self._is_include_usage = is_include_usage

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
