# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ContentModerationResult(object):
    """
    The result of content moderation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ContentModerationResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param categories:
            The value to assign to the categories property of this ContentModerationResult.
        :type categories: list[oci.generative_ai_inference.models.CategoryScore]

        """
        self.swagger_types = {
            'categories': 'list[CategoryScore]'
        }
        self.attribute_map = {
            'categories': 'categories'
        }
        self._categories = None

    @property
    def categories(self):
        """
        **[Required]** Gets the categories of this ContentModerationResult.
        A list of categories with their respective scores.


        :return: The categories of this ContentModerationResult.
        :rtype: list[oci.generative_ai_inference.models.CategoryScore]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """
        Sets the categories of this ContentModerationResult.
        A list of categories with their respective scores.


        :param categories: The categories of this ContentModerationResult.
        :type: list[oci.generative_ai_inference.models.CategoryScore]
        """
        self._categories = categories

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
