# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .model_data_source import ModelDataSource
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectStorageObject(ModelDataSource):
    """
    Details about the object storage location.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectStorageObject object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai.models.ObjectStorageObject.source_type` attribute
        of this class is ``OBJECT_STORAGE_OBJECT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_type:
            The value to assign to the source_type property of this ObjectStorageObject.
            Allowed values for this property are: "HUGGING_FACE_MODEL", "OBJECT_STORAGE_OBJECT"
        :type source_type: str

        :param namespace_name:
            The value to assign to the namespace_name property of this ObjectStorageObject.
        :type namespace_name: str

        :param bucket_name:
            The value to assign to the bucket_name property of this ObjectStorageObject.
        :type bucket_name: str

        :param prefix_name:
            The value to assign to the prefix_name property of this ObjectStorageObject.
        :type prefix_name: str

        :param region:
            The value to assign to the region property of this ObjectStorageObject.
        :type region: str

        """
        self.swagger_types = {
            'source_type': 'str',
            'namespace_name': 'str',
            'bucket_name': 'str',
            'prefix_name': 'str',
            'region': 'str'
        }
        self.attribute_map = {
            'source_type': 'sourceType',
            'namespace_name': 'namespaceName',
            'bucket_name': 'bucketName',
            'prefix_name': 'prefixName',
            'region': 'region'
        }
        self._source_type = None
        self._namespace_name = None
        self._bucket_name = None
        self._prefix_name = None
        self._region = None
        self._source_type = 'OBJECT_STORAGE_OBJECT'

    @property
    def namespace_name(self):
        """
        **[Required]** Gets the namespace_name of this ObjectStorageObject.
        The namespace of the Object Storage where the files are stored.


        :return: The namespace_name of this ObjectStorageObject.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this ObjectStorageObject.
        The namespace of the Object Storage where the files are stored.


        :param namespace_name: The namespace_name of this ObjectStorageObject.
        :type: str
        """
        self._namespace_name = namespace_name

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this ObjectStorageObject.
        The name of the Object Storage bucket.


        :return: The bucket_name of this ObjectStorageObject.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this ObjectStorageObject.
        The name of the Object Storage bucket.


        :param bucket_name: The bucket_name of this ObjectStorageObject.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def prefix_name(self):
        """
        **[Required]** Gets the prefix_name of this ObjectStorageObject.
        The prefix path (or folder) within the bucket where files are located.


        :return: The prefix_name of this ObjectStorageObject.
        :rtype: str
        """
        return self._prefix_name

    @prefix_name.setter
    def prefix_name(self, prefix_name):
        """
        Sets the prefix_name of this ObjectStorageObject.
        The prefix path (or folder) within the bucket where files are located.


        :param prefix_name: The prefix_name of this ObjectStorageObject.
        :type: str
        """
        self._prefix_name = prefix_name

    @property
    def region(self):
        """
        Gets the region of this ObjectStorageObject.
        The full canonical Oracle Cloud region identifier (e.g., \"us-ashburn-1\") where the object storage bucket
        containing the files resides.


        :return: The region of this ObjectStorageObject.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this ObjectStorageObject.
        The full canonical Oracle Cloud region identifier (e.g., \"us-ashburn-1\") where the object storage bucket
        containing the files resides.


        :param region: The region of this ObjectStorageObject.
        :type: str
        """
        self._region = region

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
