# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .fsu_goal_version_details import FsuGoalVersionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExadbStackFsuGoalVersionDetails(FsuGoalVersionDetails):
    """
    Details of goal version for an 'EXADB_STACK' type Exadata Fleet Update Collection.
    Currently, components allowed in an Exadata software stack are 'GUEST_OS' and 'GI'.
    At least two distinct component types are required for an Exadata software stack.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExadbStackFsuGoalVersionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.ExadbStackFsuGoalVersionDetails.type` attribute
        of this class is ``EXADB_STACK`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ExadbStackFsuGoalVersionDetails.
            Allowed values for this property are: "VERSION", "IMAGE_ID", "EXADB_STACK"
        :type type: str

        :param home_policy:
            The value to assign to the home_policy property of this ExadbStackFsuGoalVersionDetails.
            Allowed values for this property are: "CREATE_NEW", "USE_EXISTING"
        :type home_policy: str

        :param new_home_prefix:
            The value to assign to the new_home_prefix property of this ExadbStackFsuGoalVersionDetails.
        :type new_home_prefix: str

        :param components:
            The value to assign to the components property of this ExadbStackFsuGoalVersionDetails.
        :type components: list[oci.fleet_software_update.models.GoalSoftwareComponentDetails]

        """
        self.swagger_types = {
            'type': 'str',
            'home_policy': 'str',
            'new_home_prefix': 'str',
            'components': 'list[GoalSoftwareComponentDetails]'
        }
        self.attribute_map = {
            'type': 'type',
            'home_policy': 'homePolicy',
            'new_home_prefix': 'newHomePrefix',
            'components': 'components'
        }
        self._type = None
        self._home_policy = None
        self._new_home_prefix = None
        self._components = None
        self._type = 'EXADB_STACK'

    @property
    def components(self):
        """
        **[Required]** Gets the components of this ExadbStackFsuGoalVersionDetails.
        Details of goal versions for components in an Exadata software stack.


        :return: The components of this ExadbStackFsuGoalVersionDetails.
        :rtype: list[oci.fleet_software_update.models.GoalSoftwareComponentDetails]
        """
        return self._components

    @components.setter
    def components(self, components):
        """
        Sets the components of this ExadbStackFsuGoalVersionDetails.
        Details of goal versions for components in an Exadata software stack.


        :param components: The components of this ExadbStackFsuGoalVersionDetails.
        :type: list[oci.fleet_software_update.models.GoalSoftwareComponentDetails]
        """
        self._components = components

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
