# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .runbook_import_as import RunbookImportAs
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RunbookImportAsVersion(RunbookImportAs):
    """
    Import as Version.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RunbookImportAsVersion object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.RunbookImportAsVersion.import_type` attribute
        of this class is ``RUNBOOK_VERSION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param import_type:
            The value to assign to the import_type property of this RunbookImportAsVersion.
            Allowed values for this property are: "RUNBOOK", "RUNBOOK_VERSION"
        :type import_type: str

        :param version:
            The value to assign to the version property of this RunbookImportAsVersion.
        :type version: str

        :param import_option:
            The value to assign to the import_option property of this RunbookImportAsVersion.
        :type import_option: str

        :param runbook_id:
            The value to assign to the runbook_id property of this RunbookImportAsVersion.
        :type runbook_id: str

        """
        self.swagger_types = {
            'import_type': 'str',
            'version': 'str',
            'import_option': 'str',
            'runbook_id': 'str'
        }
        self.attribute_map = {
            'import_type': 'importType',
            'version': 'version',
            'import_option': 'importOption',
            'runbook_id': 'runbookId'
        }
        self._import_type = None
        self._version = None
        self._import_option = None
        self._runbook_id = None
        self._import_type = 'RUNBOOK_VERSION'

    @property
    def runbook_id(self):
        """
        **[Required]** Gets the runbook_id of this RunbookImportAsVersion.
        Only for VERSION importType.


        :return: The runbook_id of this RunbookImportAsVersion.
        :rtype: str
        """
        return self._runbook_id

    @runbook_id.setter
    def runbook_id(self, runbook_id):
        """
        Sets the runbook_id of this RunbookImportAsVersion.
        Only for VERSION importType.


        :param runbook_id: The runbook_id of this RunbookImportAsVersion.
        :type: str
        """
        self._runbook_id = runbook_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
