# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceTagCheckDetails(object):
    """
    Request to check resource tagging.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceTagCheckDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tag_enablement_info:
            The value to assign to the tag_enablement_info property of this ResourceTagCheckDetails.
        :type tag_enablement_info: list[oci.fleet_apps_management.models.ResourceTagEnablementInfo]

        """
        self.swagger_types = {
            'tag_enablement_info': 'list[ResourceTagEnablementInfo]'
        }
        self.attribute_map = {
            'tag_enablement_info': 'tagEnablementInfo'
        }
        self._tag_enablement_info = None

    @property
    def tag_enablement_info(self):
        """
        **[Required]** Gets the tag_enablement_info of this ResourceTagCheckDetails.
        Tag enablement Information for the resources.


        :return: The tag_enablement_info of this ResourceTagCheckDetails.
        :rtype: list[oci.fleet_apps_management.models.ResourceTagEnablementInfo]
        """
        return self._tag_enablement_info

    @tag_enablement_info.setter
    def tag_enablement_info(self, tag_enablement_info):
        """
        Sets the tag_enablement_info of this ResourceTagCheckDetails.
        Tag enablement Information for the resources.


        :param tag_enablement_info: The tag_enablement_info of this ResourceTagCheckDetails.
        :type: list[oci.fleet_apps_management.models.ResourceTagEnablementInfo]
        """
        self._tag_enablement_info = tag_enablement_info

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
