# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .config_file_details import ConfigFileDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectStorageBucketConfigFileDetails(ConfigFileDetails):
    """
    Details about Object Storage Bucket source.
    Restricted to the region this is called.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectStorageBucketConfigFileDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.ObjectStorageBucketConfigFileDetails.source_type` attribute
        of this class is ``OBJECT_STORAGE_BUCKET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_type:
            The value to assign to the source_type property of this ObjectStorageBucketConfigFileDetails.
            Allowed values for this property are: "OBJECT_STORAGE_BUCKET"
        :type source_type: str

        :param namespace_name:
            The value to assign to the namespace_name property of this ObjectStorageBucketConfigFileDetails.
        :type namespace_name: str

        :param bucket_name:
            The value to assign to the bucket_name property of this ObjectStorageBucketConfigFileDetails.
        :type bucket_name: str

        :param object_name:
            The value to assign to the object_name property of this ObjectStorageBucketConfigFileDetails.
        :type object_name: str

        :param checksum:
            The value to assign to the checksum property of this ObjectStorageBucketConfigFileDetails.
        :type checksum: str

        """
        self.swagger_types = {
            'source_type': 'str',
            'namespace_name': 'str',
            'bucket_name': 'str',
            'object_name': 'str',
            'checksum': 'str'
        }
        self.attribute_map = {
            'source_type': 'sourceType',
            'namespace_name': 'namespaceName',
            'bucket_name': 'bucketName',
            'object_name': 'objectName',
            'checksum': 'checksum'
        }
        self._source_type = None
        self._namespace_name = None
        self._bucket_name = None
        self._object_name = None
        self._checksum = None
        self._source_type = 'OBJECT_STORAGE_BUCKET'

    @property
    def namespace_name(self):
        """
        **[Required]** Gets the namespace_name of this ObjectStorageBucketConfigFileDetails.
        Namespace.


        :return: The namespace_name of this ObjectStorageBucketConfigFileDetails.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this ObjectStorageBucketConfigFileDetails.
        Namespace.


        :param namespace_name: The namespace_name of this ObjectStorageBucketConfigFileDetails.
        :type: str
        """
        self._namespace_name = namespace_name

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this ObjectStorageBucketConfigFileDetails.
        Bucket Name.


        :return: The bucket_name of this ObjectStorageBucketConfigFileDetails.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this ObjectStorageBucketConfigFileDetails.
        Bucket Name.


        :param bucket_name: The bucket_name of this ObjectStorageBucketConfigFileDetails.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def object_name(self):
        """
        **[Required]** Gets the object_name of this ObjectStorageBucketConfigFileDetails.
        Object Name.


        :return: The object_name of this ObjectStorageBucketConfigFileDetails.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this ObjectStorageBucketConfigFileDetails.
        Object Name.


        :param object_name: The object_name of this ObjectStorageBucketConfigFileDetails.
        :type: str
        """
        self._object_name = object_name

    @property
    def checksum(self):
        """
        **[Required]** Gets the checksum of this ObjectStorageBucketConfigFileDetails.
        md5 checksum of the artifact.


        :return: The checksum of this ObjectStorageBucketConfigFileDetails.
        :rtype: str
        """
        return self._checksum

    @checksum.setter
    def checksum(self, checksum):
        """
        Sets the checksum of this ObjectStorageBucketConfigFileDetails.
        md5 checksum of the artifact.


        :param checksum: The checksum of this ObjectStorageBucketConfigFileDetails.
        :type: str
        """
        self._checksum = checksum

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
