# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FleetCredentialSummary(object):
    """
    Summary of the FleetCredential.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FleetCredentialSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this FleetCredentialSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this FleetCredentialSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this FleetCredentialSummary.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this FleetCredentialSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this FleetCredentialSummary.
        :type time_updated: datetime

        :param entity_specifics:
            The value to assign to the entity_specifics property of this FleetCredentialSummary.
        :type entity_specifics: oci.fleet_apps_management.models.CredentialEntitySpecificDetails

        :param user:
            The value to assign to the user property of this FleetCredentialSummary.
        :type user: oci.fleet_apps_management.models.CredentialDetails

        :param password:
            The value to assign to the password property of this FleetCredentialSummary.
        :type password: oci.fleet_apps_management.models.CredentialDetails

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this FleetCredentialSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this FleetCredentialSummary.
        :type lifecycle_details: str

        :param system_tags:
            The value to assign to the system_tags property of this FleetCredentialSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'entity_specifics': 'CredentialEntitySpecificDetails',
            'user': 'CredentialDetails',
            'password': 'CredentialDetails',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'entity_specifics': 'entitySpecifics',
            'user': 'user',
            'password': 'password',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._time_created = None
        self._time_updated = None
        self._entity_specifics = None
        self._user = None
        self._password = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this FleetCredentialSummary.
        The unique id of the resource.


        :return: The id of this FleetCredentialSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FleetCredentialSummary.
        The unique id of the resource.


        :param id: The id of this FleetCredentialSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this FleetCredentialSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this FleetCredentialSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this FleetCredentialSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this FleetCredentialSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this FleetCredentialSummary.
        Compartment OCID


        :return: The compartment_id of this FleetCredentialSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FleetCredentialSummary.
        Compartment OCID


        :param compartment_id: The compartment_id of this FleetCredentialSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this FleetCredentialSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this FleetCredentialSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this FleetCredentialSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this FleetCredentialSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this FleetCredentialSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this FleetCredentialSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this FleetCredentialSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this FleetCredentialSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def entity_specifics(self):
        """
        **[Required]** Gets the entity_specifics of this FleetCredentialSummary.

        :return: The entity_specifics of this FleetCredentialSummary.
        :rtype: oci.fleet_apps_management.models.CredentialEntitySpecificDetails
        """
        return self._entity_specifics

    @entity_specifics.setter
    def entity_specifics(self, entity_specifics):
        """
        Sets the entity_specifics of this FleetCredentialSummary.

        :param entity_specifics: The entity_specifics of this FleetCredentialSummary.
        :type: oci.fleet_apps_management.models.CredentialEntitySpecificDetails
        """
        self._entity_specifics = entity_specifics

    @property
    def user(self):
        """
        Gets the user of this FleetCredentialSummary.

        :return: The user of this FleetCredentialSummary.
        :rtype: oci.fleet_apps_management.models.CredentialDetails
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this FleetCredentialSummary.

        :param user: The user of this FleetCredentialSummary.
        :type: oci.fleet_apps_management.models.CredentialDetails
        """
        self._user = user

    @property
    def password(self):
        """
        Gets the password of this FleetCredentialSummary.

        :return: The password of this FleetCredentialSummary.
        :rtype: oci.fleet_apps_management.models.CredentialDetails
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this FleetCredentialSummary.

        :param password: The password of this FleetCredentialSummary.
        :type: oci.fleet_apps_management.models.CredentialDetails
        """
        self._password = password

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this FleetCredentialSummary.
        The current state of the FleetCredential.


        :return: The lifecycle_state of this FleetCredentialSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this FleetCredentialSummary.
        The current state of the FleetCredential.


        :param lifecycle_state: The lifecycle_state of this FleetCredentialSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this FleetCredentialSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this FleetCredentialSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this FleetCredentialSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this FleetCredentialSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def system_tags(self):
        """
        Gets the system_tags of this FleetCredentialSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this FleetCredentialSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this FleetCredentialSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this FleetCredentialSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
