# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConfigureCatalogItemDetails(object):
    """
    Contains the details required to configure a catalog item.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ConfigureCatalogItemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param storage_namespace:
            The value to assign to the storage_namespace property of this ConfigureCatalogItemDetails.
        :type storage_namespace: str

        :param bucket_name:
            The value to assign to the bucket_name property of this ConfigureCatalogItemDetails.
        :type bucket_name: str

        :param object_name:
            The value to assign to the object_name property of this ConfigureCatalogItemDetails.
        :type object_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ConfigureCatalogItemDetails.
        :type compartment_id: str

        :param catalog_listing_id:
            The value to assign to the catalog_listing_id property of this ConfigureCatalogItemDetails.
        :type catalog_listing_id: str

        :param catalog_listing_version_id:
            The value to assign to the catalog_listing_version_id property of this ConfigureCatalogItemDetails.
        :type catalog_listing_version_id: str

        :param input_variables:
            The value to assign to the input_variables property of this ConfigureCatalogItemDetails.
        :type input_variables: list[oci.fleet_apps_management.models.KeyValueProperty]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ConfigureCatalogItemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ConfigureCatalogItemDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ConfigureCatalogItemDetails.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'storage_namespace': 'str',
            'bucket_name': 'str',
            'object_name': 'str',
            'compartment_id': 'str',
            'catalog_listing_id': 'str',
            'catalog_listing_version_id': 'str',
            'input_variables': 'list[KeyValueProperty]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'storage_namespace': 'storageNamespace',
            'bucket_name': 'bucketName',
            'object_name': 'objectName',
            'compartment_id': 'compartmentId',
            'catalog_listing_id': 'catalogListingId',
            'catalog_listing_version_id': 'catalogListingVersionId',
            'input_variables': 'inputVariables',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._storage_namespace = None
        self._bucket_name = None
        self._object_name = None
        self._compartment_id = None
        self._catalog_listing_id = None
        self._catalog_listing_version_id = None
        self._input_variables = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def storage_namespace(self):
        """
        **[Required]** Gets the storage_namespace of this ConfigureCatalogItemDetails.
        The Oracle Cloud Object Storage namespace where the artifact or variables are stored.


        :return: The storage_namespace of this ConfigureCatalogItemDetails.
        :rtype: str
        """
        return self._storage_namespace

    @storage_namespace.setter
    def storage_namespace(self, storage_namespace):
        """
        Sets the storage_namespace of this ConfigureCatalogItemDetails.
        The Oracle Cloud Object Storage namespace where the artifact or variables are stored.


        :param storage_namespace: The storage_namespace of this ConfigureCatalogItemDetails.
        :type: str
        """
        self._storage_namespace = storage_namespace

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this ConfigureCatalogItemDetails.
        The name of the Object Storage bucket that contains the catalog item configuration object.


        :return: The bucket_name of this ConfigureCatalogItemDetails.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this ConfigureCatalogItemDetails.
        The name of the Object Storage bucket that contains the catalog item configuration object.


        :param bucket_name: The bucket_name of this ConfigureCatalogItemDetails.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def object_name(self):
        """
        Gets the object_name of this ConfigureCatalogItemDetails.
        The name of the object file in the specified bucket containing catalog item configuration details.


        :return: The object_name of this ConfigureCatalogItemDetails.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this ConfigureCatalogItemDetails.
        The name of the object file in the specified bucket containing catalog item configuration details.


        :param object_name: The object_name of this ConfigureCatalogItemDetails.
        :type: str
        """
        self._object_name = object_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ConfigureCatalogItemDetails.
        OCID of the Compartment.


        :return: The compartment_id of this ConfigureCatalogItemDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ConfigureCatalogItemDetails.
        OCID of the Compartment.


        :param compartment_id: The compartment_id of this ConfigureCatalogItemDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def catalog_listing_id(self):
        """
        Gets the catalog_listing_id of this ConfigureCatalogItemDetails.
        The unique identifier of the catalog listing to which configuration applies.


        :return: The catalog_listing_id of this ConfigureCatalogItemDetails.
        :rtype: str
        """
        return self._catalog_listing_id

    @catalog_listing_id.setter
    def catalog_listing_id(self, catalog_listing_id):
        """
        Sets the catalog_listing_id of this ConfigureCatalogItemDetails.
        The unique identifier of the catalog listing to which configuration applies.


        :param catalog_listing_id: The catalog_listing_id of this ConfigureCatalogItemDetails.
        :type: str
        """
        self._catalog_listing_id = catalog_listing_id

    @property
    def catalog_listing_version_id(self):
        """
        Gets the catalog_listing_version_id of this ConfigureCatalogItemDetails.
        The unique identifier for the specific version of the catalog listing.


        :return: The catalog_listing_version_id of this ConfigureCatalogItemDetails.
        :rtype: str
        """
        return self._catalog_listing_version_id

    @catalog_listing_version_id.setter
    def catalog_listing_version_id(self, catalog_listing_version_id):
        """
        Sets the catalog_listing_version_id of this ConfigureCatalogItemDetails.
        The unique identifier for the specific version of the catalog listing.


        :param catalog_listing_version_id: The catalog_listing_version_id of this ConfigureCatalogItemDetails.
        :type: str
        """
        self._catalog_listing_version_id = catalog_listing_version_id

    @property
    def input_variables(self):
        """
        **[Required]** Gets the input_variables of this ConfigureCatalogItemDetails.
        Array of key value pairs specifying variables or parameters to be used when configuring the catalog item.


        :return: The input_variables of this ConfigureCatalogItemDetails.
        :rtype: list[oci.fleet_apps_management.models.KeyValueProperty]
        """
        return self._input_variables

    @input_variables.setter
    def input_variables(self, input_variables):
        """
        Sets the input_variables of this ConfigureCatalogItemDetails.
        Array of key value pairs specifying variables or parameters to be used when configuring the catalog item.


        :param input_variables: The input_variables of this ConfigureCatalogItemDetails.
        :type: list[oci.fleet_apps_management.models.KeyValueProperty]
        """
        self._input_variables = input_variables

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ConfigureCatalogItemDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this ConfigureCatalogItemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ConfigureCatalogItemDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this ConfigureCatalogItemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ConfigureCatalogItemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ConfigureCatalogItemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ConfigureCatalogItemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ConfigureCatalogItemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ConfigureCatalogItemDetails.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ConfigureCatalogItemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ConfigureCatalogItemDetails.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ConfigureCatalogItemDetails.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
