# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .catalog_source_payload import CatalogSourcePayload
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogSourceTemplateConfig(CatalogSourcePayload):
    """
    Catalog source template config.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogSourceTemplateConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.CatalogSourceTemplateConfig.config_source_type` attribute
        of this class is ``STACK_TEMPLATE_CATALOG_SOURCE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_source_type:
            The value to assign to the config_source_type property of this CatalogSourceTemplateConfig.
        :type config_source_type: str

        :param working_directory:
            The value to assign to the working_directory property of this CatalogSourceTemplateConfig.
        :type working_directory: str

        :param zip_file_base64_encoded:
            The value to assign to the zip_file_base64_encoded property of this CatalogSourceTemplateConfig.
        :type zip_file_base64_encoded: str

        :param description:
            The value to assign to the description property of this CatalogSourceTemplateConfig.
        :type description: str

        :param long_description:
            The value to assign to the long_description property of this CatalogSourceTemplateConfig.
        :type long_description: str

        :param template_display_name:
            The value to assign to the template_display_name property of this CatalogSourceTemplateConfig.
        :type template_display_name: str

        """
        self.swagger_types = {
            'config_source_type': 'str',
            'working_directory': 'str',
            'zip_file_base64_encoded': 'str',
            'description': 'str',
            'long_description': 'str',
            'template_display_name': 'str'
        }
        self.attribute_map = {
            'config_source_type': 'configSourceType',
            'working_directory': 'workingDirectory',
            'zip_file_base64_encoded': 'zipFileBase64Encoded',
            'description': 'description',
            'long_description': 'longDescription',
            'template_display_name': 'templateDisplayName'
        }
        self._config_source_type = None
        self._working_directory = None
        self._zip_file_base64_encoded = None
        self._description = None
        self._long_description = None
        self._template_display_name = None
        self._config_source_type = 'STACK_TEMPLATE_CATALOG_SOURCE'

    @property
    def zip_file_base64_encoded(self):
        """
        Gets the zip_file_base64_encoded of this CatalogSourceTemplateConfig.
        The Base64 encoded template. This payload will trigger CreateTemplate API, where the parameter will be passed.


        :return: The zip_file_base64_encoded of this CatalogSourceTemplateConfig.
        :rtype: str
        """
        return self._zip_file_base64_encoded

    @zip_file_base64_encoded.setter
    def zip_file_base64_encoded(self, zip_file_base64_encoded):
        """
        Sets the zip_file_base64_encoded of this CatalogSourceTemplateConfig.
        The Base64 encoded template. This payload will trigger CreateTemplate API, where the parameter will be passed.


        :param zip_file_base64_encoded: The zip_file_base64_encoded of this CatalogSourceTemplateConfig.
        :type: str
        """
        self._zip_file_base64_encoded = zip_file_base64_encoded

    @property
    def description(self):
        """
        Gets the description of this CatalogSourceTemplateConfig.
        Template Description


        :return: The description of this CatalogSourceTemplateConfig.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CatalogSourceTemplateConfig.
        Template Description


        :param description: The description of this CatalogSourceTemplateConfig.
        :type: str
        """
        self._description = description

    @property
    def long_description(self):
        """
        Gets the long_description of this CatalogSourceTemplateConfig.
        Template Long Description


        :return: The long_description of this CatalogSourceTemplateConfig.
        :rtype: str
        """
        return self._long_description

    @long_description.setter
    def long_description(self, long_description):
        """
        Sets the long_description of this CatalogSourceTemplateConfig.
        Template Long Description


        :param long_description: The long_description of this CatalogSourceTemplateConfig.
        :type: str
        """
        self._long_description = long_description

    @property
    def template_display_name(self):
        """
        Gets the template_display_name of this CatalogSourceTemplateConfig.
        Template Display Name


        :return: The template_display_name of this CatalogSourceTemplateConfig.
        :rtype: str
        """
        return self._template_display_name

    @template_display_name.setter
    def template_display_name(self, template_display_name):
        """
        Sets the template_display_name of this CatalogSourceTemplateConfig.
        Template Display Name


        :param template_display_name: The template_display_name of this CatalogSourceTemplateConfig.
        :type: str
        """
        self._template_display_name = template_display_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
